/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.openpgp.api.OpenPGPCertificate;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKey;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKeyMaterialProvider;

public abstract class OpenPGPKeyMaterialPool<M extends OpenPGPCertificate>
implements OpenPGPKeyMaterialProvider<M> {
    private final Map<KeyIdentifier, M> pool = new HashMap<KeyIdentifier, M>();
    private OpenPGPKeyMaterialProvider<M> callback = null;
    private boolean cacheResultsFromCallback = true;

    public OpenPGPKeyMaterialPool() {
    }

    public OpenPGPKeyMaterialPool(M m) {
        this.addItem(m);
    }

    public OpenPGPKeyMaterialPool(Collection<M> collection) {
        for (OpenPGPCertificate openPGPCertificate : collection) {
            this.addItem(openPGPCertificate);
        }
    }

    public OpenPGPKeyMaterialPool<M> setMissingItemCallback(OpenPGPKeyMaterialProvider<M> openPGPKeyMaterialProvider) {
        if (openPGPKeyMaterialProvider == null) {
            throw new NullPointerException();
        }
        this.callback = openPGPKeyMaterialProvider;
        return this;
    }

    public OpenPGPKeyMaterialPool<M> setCacheResultsFromCallback(boolean bl) {
        this.cacheResultsFromCallback = bl;
        return this;
    }

    @Override
    public M provide(KeyIdentifier keyIdentifier) {
        OpenPGPCertificate openPGPCertificate = (OpenPGPCertificate)this.pool.get(keyIdentifier);
        if (openPGPCertificate == null && this.callback != null) {
            openPGPCertificate = this.callback.provide(keyIdentifier);
            if (this.cacheResultsFromCallback) {
                this.addItem(openPGPCertificate);
            }
        }
        return (M)openPGPCertificate;
    }

    public OpenPGPKeyMaterialPool<M> addItem(M m) {
        if (m != null) {
            Iterator<KeyIdentifier> iterator = ((OpenPGPCertificate)m).getAllKeyIdentifiers().iterator();
            while (iterator.hasNext()) {
                this.pool.put(iterator.next(), m);
            }
        }
        return this;
    }

    public Collection<M> getAllItems() {
        Stream<M> stream = this.pool.values().stream().distinct();
        return stream.collect(Collectors.toList());
    }

    public static class OpenPGPCertificatePool
    extends OpenPGPKeyMaterialPool<OpenPGPCertificate>
    implements OpenPGPKeyMaterialProvider.OpenPGPCertificateProvider {
        public OpenPGPCertificatePool() {
        }

        public OpenPGPCertificatePool(Collection<OpenPGPCertificate> collection) {
            super(collection);
        }

        public OpenPGPCertificatePool setMissingItemCallback(OpenPGPKeyMaterialProvider<OpenPGPCertificate> openPGPKeyMaterialProvider) {
            super.setMissingItemCallback(openPGPKeyMaterialProvider);
            return this;
        }

        public OpenPGPCertificatePool setCacheResultsFromCallback(boolean bl) {
            super.setCacheResultsFromCallback(bl);
            return this;
        }

        public OpenPGPCertificatePool addItem(OpenPGPCertificate openPGPCertificate) {
            super.addItem(openPGPCertificate);
            return this;
        }
    }

    public static class OpenPGPKeyPool
    extends OpenPGPKeyMaterialPool<OpenPGPKey>
    implements OpenPGPKeyMaterialProvider.OpenPGPKeyProvider {
        public OpenPGPKeyPool() {
        }

        public OpenPGPKeyPool(Collection<OpenPGPKey> collection) {
            super(collection);
        }

        public OpenPGPKeyPool setMissingItemCallback(OpenPGPKeyMaterialProvider<OpenPGPKey> openPGPKeyMaterialProvider) {
            super.setMissingItemCallback(openPGPKeyMaterialProvider);
            return this;
        }

        public OpenPGPKeyPool setCacheResultsFromCallback(boolean bl) {
            super.setCacheResultsFromCallback(bl);
            return this;
        }

        public OpenPGPKeyPool addItem(OpenPGPKey openPGPKey) {
            super.addItem(openPGPKey);
            return this;
        }
    }
}

