/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.bcpg.PacketFormat;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKeyPair;
import shadow.org.bouncycastle.openpgp.PGPKeyValidationException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPSecretKey;
import shadow.org.bouncycastle.openpgp.PGPSecretKeyRing;
import shadow.org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import shadow.org.bouncycastle.openpgp.api.OpenPGPCertificate;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.api.OpenPGPPolicy;
import shadow.org.bouncycastle.openpgp.api.exception.KeyPassphraseException;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;

public class OpenPGPKey
extends OpenPGPCertificate {
    private final Map<KeyIdentifier, OpenPGPSecretKey> secretKeys = new LinkedHashMap<KeyIdentifier, OpenPGPSecretKey>();

    public OpenPGPKey(PGPSecretKeyRing pGPSecretKeyRing) {
        this(pGPSecretKeyRing, OpenPGPImplementation.getInstance());
    }

    public OpenPGPKey(PGPSecretKeyRing pGPSecretKeyRing, OpenPGPImplementation openPGPImplementation) {
        this(pGPSecretKeyRing, openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPKey(PGPSecretKeyRing pGPSecretKeyRing, OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        super(pGPSecretKeyRing, openPGPImplementation, openPGPPolicy);
        for (OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey : this.getKeys()) {
            KeyIdentifier keyIdentifier = openPGPComponentKey.getKeyIdentifier();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(keyIdentifier);
            if (pGPSecretKey == null) continue;
            this.secretKeys.put(keyIdentifier, new OpenPGPSecretKey(openPGPComponentKey, pGPSecretKey, openPGPImplementation.pbeSecretKeyDecryptorBuilderProvider()));
        }
    }

    @Override
    public boolean isSecretKey() {
        return true;
    }

    public OpenPGPCertificate toCertificate() {
        return new OpenPGPCertificate(this.getPGPPublicKeyRing(), this.implementation, this.policy);
    }

    @Override
    public List<OpenPGPCertificate.OpenPGPCertificateComponent> getComponents() {
        List<OpenPGPCertificate.OpenPGPCertificateComponent> list = super.getComponents();
        for (int i = list.size() - 1; i >= 0; --i) {
            OpenPGPSecretKey openPGPSecretKey;
            OpenPGPCertificate.OpenPGPCertificateComponent openPGPCertificateComponent = list.get(i);
            if (!(openPGPCertificateComponent instanceof OpenPGPCertificate.OpenPGPComponentKey) || (openPGPSecretKey = this.getSecretKey((OpenPGPCertificate.OpenPGPComponentKey)openPGPCertificateComponent)) == null) continue;
            list.remove(i);
            list.add(i, openPGPSecretKey);
        }
        return list;
    }

    public OpenPGPSecretKey getPrimarySecretKey() {
        return this.getSecretKey(this.getPrimaryKey());
    }

    public Map<KeyIdentifier, OpenPGPSecretKey> getSecretKeys() {
        return new LinkedHashMap<KeyIdentifier, OpenPGPSecretKey>(this.secretKeys);
    }

    public OpenPGPSecretKey getSecretKey(KeyIdentifier keyIdentifier) {
        return this.secretKeys.get(keyIdentifier);
    }

    public OpenPGPSecretKey getSecretKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) {
        return this.getSecretKey(openPGPComponentKey.getKeyIdentifier());
    }

    void replaceSecretKey(OpenPGPSecretKey openPGPSecretKey) {
        this.keyRing = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)this.keyRing, openPGPSecretKey.rawSecKey);
        this.secretKeys.put(openPGPSecretKey.getKeyIdentifier(), openPGPSecretKey);
    }

    @Override
    public PGPSecretKeyRing getPGPKeyRing() {
        return this.getPGPSecretKeyRing();
    }

    public PGPSecretKeyRing getPGPSecretKeyRing() {
        return (PGPSecretKeyRing)super.getPGPKeyRing();
    }

    @Override
    public byte[] getEncoded(PacketFormat packetFormat) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)byteArrayOutputStream, packetFormat);
        this.getPGPSecretKeyRing().encode(bCPGOutputStream);
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static class OpenPGPPrivateKey {
        private final OpenPGPSecretKey secretKey;
        private final PGPKeyPair unlockedKey;

        public OpenPGPPrivateKey(OpenPGPSecretKey openPGPSecretKey, PGPKeyPair pGPKeyPair) {
            this.secretKey = openPGPSecretKey;
            this.unlockedKey = pGPKeyPair;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getPublicKey() {
            return this.secretKey.getPublicKey();
        }

        public OpenPGPSecretKey getSecretKey() {
            return this.secretKey;
        }

        public PGPKeyPair getKeyPair() {
            return this.unlockedKey;
        }

        private OpenPGPImplementation getImplementation() {
            return this.getSecretKey().getOpenPGPKey().implementation;
        }

        public OpenPGPSecretKey changePassphrase(char[] cArray) throws PGPException {
            boolean bl = !this.secretKey.isLocked() || this.secretKey.getPGPSecretKey().getS2KUsage() == 253;
            return this.changePassphrase(cArray, this.getImplementation(), bl);
        }

        public OpenPGPSecretKey changePassphrase(char[] cArray, OpenPGPImplementation openPGPImplementation, boolean bl) throws PGPException {
            return this.changePassphrase(cArray, openPGPImplementation.pbeSecretKeyEncryptorFactory(bl));
        }

        public OpenPGPSecretKey changePassphrase(char[] cArray, PBESecretKeyEncryptorFactory pBESecretKeyEncryptorFactory) throws PGPException {
            PBESecretKeyEncryptor pBESecretKeyEncryptor = cArray == null || cArray.length == 0 ? null : pBESecretKeyEncryptorFactory.build(cArray, this.getKeyPair().getPublicKey().getPublicKeyPacket());
            return this.changePassphrase(pBESecretKeyEncryptor);
        }

        public OpenPGPSecretKey changePassphrase(PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
            PGPSecretKey pGPSecretKey = new PGPSecretKey(this.getKeyPair().getPrivateKey(), this.getKeyPair().getPublicKey(), this.getImplementation().pgpDigestCalculatorProvider().get(2), this.getSecretKey().isPrimaryKey(), pBESecretKeyEncryptor);
            OpenPGPSecretKey openPGPSecretKey = new OpenPGPSecretKey(this.getSecretKey().getPublicKey(), pGPSecretKey, this.getImplementation().pbeSecretKeyDecryptorBuilderProvider());
            openPGPSecretKey.sanitizeProtectionMode();
            return openPGPSecretKey;
        }

        public OpenPGPSecretKey removePassphrase() throws PGPException {
            return this.changePassphrase((PBESecretKeyEncryptor)null);
        }
    }

    public static class OpenPGPSecretKey
    extends OpenPGPCertificate.OpenPGPComponentKey {
        private final PGPSecretKey rawSecKey;
        private final OpenPGPCertificate.OpenPGPComponentKey pubKey;
        private final PBESecretKeyDecryptorBuilderProvider decryptorBuilderProvider;

        public OpenPGPSecretKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, PGPSecretKey pGPSecretKey, PBESecretKeyDecryptorBuilderProvider pBESecretKeyDecryptorBuilderProvider) {
            super(openPGPComponentKey.getPGPPublicKey(), openPGPComponentKey.getCertificate());
            this.decryptorBuilderProvider = pBESecretKeyDecryptorBuilderProvider;
            this.rawSecKey = pGPSecretKey;
            this.pubKey = openPGPComponentKey;
        }

        @Override
        protected OpenPGPCertificate.OpenPGPCertificateComponent getPublicComponent() {
            return this.pubKey;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.getPublicKey().isPrimaryKey();
        }

        @Override
        public OpenPGPCertificate.OpenPGPComponentSignature getLatestSelfSignature(Date date) {
            return this.getPublicKey().getLatestSelfSignature(date);
        }

        public OpenPGPKey getOpenPGPKey() {
            return (OpenPGPKey)this.getCertificate();
        }

        @Override
        public String toDetailString() {
            return "Private" + this.pubKey.toDetailString();
        }

        public PGPSecretKey getPGPSecretKey() {
            return this.rawSecKey;
        }

        public OpenPGPCertificate.OpenPGPComponentKey getPublicKey() {
            return this.pubKey;
        }

        public boolean isLocked() {
            return this.getPGPSecretKey().getS2KUsage() != 0;
        }

        public OpenPGPPrivateKey unlock() throws PGPException {
            return this.unlock((char[])null);
        }

        public OpenPGPPrivateKey unlock(KeyPassphraseProvider keyPassphraseProvider) throws PGPException {
            if (!this.isLocked()) {
                return this.unlock((char[])null);
            }
            return this.unlock(keyPassphraseProvider.getKeyPassword(this));
        }

        public OpenPGPPrivateKey unlock(char[] cArray) throws PGPException {
            this.sanitizeProtectionMode();
            PBESecretKeyDecryptor pBESecretKeyDecryptor = null;
            try {
                PGPPrivateKey pGPPrivateKey;
                if (cArray != null) {
                    pBESecretKeyDecryptor = this.decryptorBuilderProvider.provide().build(cArray);
                }
                if ((pGPPrivateKey = this.getPGPSecretKey().extractPrivateKey(pBESecretKeyDecryptor)) == null) {
                    return null;
                }
                PGPKeyPair pGPKeyPair = new PGPKeyPair(this.getPGPSecretKey().getPublicKey(), pGPPrivateKey);
                return new OpenPGPPrivateKey(this, pGPKeyPair);
            }
            catch (PGPException pGPException) {
                throw new KeyPassphraseException((OpenPGPCertificate.OpenPGPComponentKey)this, (Exception)pGPException);
            }
        }

        private void sanitizeProtectionMode() throws PGPException {
            if (!this.isLocked()) {
                return;
            }
            PGPSecretKey pGPSecretKey = this.getPGPSecretKey();
            S2K s2K = pGPSecretKey.getS2K();
            if (s2K == null) {
                throw new PGPKeyValidationException("Legacy CFB using MD5 is not allowed.");
            }
            if (s2K.getType() == 4 && pGPSecretKey.getS2KUsage() != 253) {
                throw new PGPKeyValidationException("Argon2 without AEAD is not allowed.");
            }
            if (this.getVersion() == 6) {
                if (pGPSecretKey.getS2KUsage() == 255) {
                    throw new PGPKeyValidationException("Version 6 keys MUST NOT use malleable CFB.");
                }
                if (s2K.getType() == 0) {
                    throw new PGPKeyValidationException("Version 6 keys MUST NOT use SIMPLE S2K.");
                }
            }
        }

        public boolean isPassphraseCorrect(char[] cArray) {
            if (cArray != null && !this.isLocked()) {
                return false;
            }
            try {
                OpenPGPPrivateKey openPGPPrivateKey = this.unlock(cArray);
                return openPGPPrivateKey != null && openPGPPrivateKey.unlockedKey != null;
            }
            catch (PGPException pGPException) {
                return false;
            }
        }
    }
}

