/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.S2K;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPObjectFactory;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.api.OpenPGPDefaultPolicy;
import shadow.org.bouncycastle.openpgp.api.OpenPGPPolicy;
import shadow.org.bouncycastle.openpgp.api.bc.BcOpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import shadow.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import shadow.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import shadow.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;

public abstract class OpenPGPImplementation {
    private static OpenPGPImplementation INSTANCE;
    private OpenPGPPolicy policy = new OpenPGPDefaultPolicy();

    public static void setInstance(OpenPGPImplementation openPGPImplementation) {
        INSTANCE = openPGPImplementation;
    }

    public static OpenPGPImplementation getInstance() {
        if (INSTANCE == null) {
            OpenPGPImplementation.setInstance(new BcOpenPGPImplementation());
        }
        return INSTANCE;
    }

    public OpenPGPPolicy policy() {
        return this.policy;
    }

    public OpenPGPImplementation setPolicy(OpenPGPPolicy openPGPPolicy) {
        this.policy = openPGPPolicy;
        return this;
    }

    public abstract PGPObjectFactory pgpObjectFactory(InputStream var1);

    public abstract PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider();

    public abstract PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider();

    public abstract PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int var1);

    public abstract PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey var1);

    public abstract PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] var1);

    public abstract PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] var1, S2K.Argon2Params var2);

    public abstract PGPContentSignerBuilder pgpContentSignerBuilder(int var1, int var2);

    public abstract PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] var1) throws PGPException;

    public abstract SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey var1);

    public abstract PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey var1);

    public abstract PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException;

    public abstract PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider();

    public abstract PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int var1);

    public abstract KeyFingerPrintCalculator keyFingerPrintCalculator();

    public abstract PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean var1) throws PGPException;

    public abstract PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean var1, int var2, int var3) throws PGPException;
}

