/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPObjectFactory;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPSignatureException;
import shadow.org.bouncycastle.openpgp.PGPSignatureList;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.api.OpenPGPCertificate;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKeyMaterialPool;
import shadow.org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import shadow.org.bouncycastle.openpgp.api.OpenPGPPolicy;
import shadow.org.bouncycastle.openpgp.api.OpenPGPSignature;

public class OpenPGPDetachedSignatureProcessor {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;
    private final OpenPGPKeyMaterialPool.OpenPGPCertificatePool certificatePool = new OpenPGPKeyMaterialPool.OpenPGPCertificatePool();
    private final List<PGPSignature> pgpSignatures = new ArrayList<PGPSignature>();
    private Date verifyNotAfter = new Date();
    private Date verifyNotBefore = new Date(0L);
    private OpenPGPMessageProcessor.PGPExceptionCallback exceptionCallback = null;

    public OpenPGPDetachedSignatureProcessor() {
        this(OpenPGPImplementation.getInstance());
    }

    public OpenPGPDetachedSignatureProcessor(OpenPGPImplementation openPGPImplementation) {
        this(openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPDetachedSignatureProcessor(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
    }

    public OpenPGPDetachedSignatureProcessor addSignatures(InputStream inputStream) throws IOException {
        Object object;
        InputStream inputStream2 = PGPUtil.getDecoderStream(inputStream);
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream2);
        PGPObjectFactory pGPObjectFactory = this.implementation.pgpObjectFactory(bCPGInputStream);
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (object instanceof PGPSignatureList) {
                this.addSignatures((PGPSignatureList)object);
                continue;
            }
            if (!(object instanceof PGPSignature)) continue;
            this.addSignature((PGPSignature)object);
        }
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addSignatures(PGPSignatureList pGPSignatureList) {
        Iterator<PGPSignature> iterator = pGPSignatureList.iterator();
        while (iterator.hasNext()) {
            this.addSignature(iterator.next());
        }
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addSignature(PGPSignature pGPSignature) {
        this.pgpSignatures.add(pGPSignature);
        return this;
    }

    public OpenPGPDetachedSignatureProcessor addVerificationCertificate(OpenPGPCertificate openPGPCertificate) {
        this.certificatePool.addItem(openPGPCertificate);
        return this;
    }

    public OpenPGPDetachedSignatureProcessor verifyNotBefore(Date date) {
        this.verifyNotBefore = date;
        return this;
    }

    public OpenPGPDetachedSignatureProcessor verifyNotAfter(Date date) {
        this.verifyNotAfter = date;
        return this;
    }

    public List<OpenPGPSignature.OpenPGPDocumentSignature> process(InputStream inputStream) throws IOException {
        int n;
        Object object;
        ArrayList<OpenPGPSignature.OpenPGPDocumentSignature> arrayList = new ArrayList<OpenPGPSignature.OpenPGPDocumentSignature>();
        for (PGPSignature pGPSignature : this.pgpSignatures) {
            OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey;
            Object m;
            object = OpenPGPSignature.getMostExpressiveIdentifier(pGPSignature.getKeyIdentifiers());
            if (object == null || (m = this.certificatePool.provide((KeyIdentifier)object)) == null || (openPGPComponentKey = ((OpenPGPCertificate)m).getKey((KeyIdentifier)object)) == null) continue;
            try {
                pGPSignature.init(this.implementation.pgpContentVerifierBuilderProvider(), openPGPComponentKey.getPGPPublicKey());
            }
            catch (PGPException pGPException) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(pGPException);
                continue;
            }
            OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature = new OpenPGPSignature.OpenPGPDocumentSignature(pGPSignature, openPGPComponentKey);
            try {
                openPGPDocumentSignature.sanitize(openPGPComponentKey, this.policy);
            }
            catch (PGPSignatureException pGPSignatureException) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(pGPSignatureException);
                continue;
            }
            if (!openPGPDocumentSignature.createdInBounds(this.verifyNotBefore, this.verifyNotAfter)) continue;
            arrayList.add(openPGPDocumentSignature);
        }
        Object object2 = new byte[2048];
        while ((n = inputStream.read((byte[])object2)) != -1) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((OpenPGPSignature.OpenPGPDocumentSignature)object.next()).getSignature().update((byte[])object2, 0, n);
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                ((OpenPGPSignature.OpenPGPDocumentSignature)object.next()).verify();
            }
            catch (PGPException pGPException) {
                if (this.exceptionCallback == null) continue;
                this.exceptionCallback.onException(pGPException);
            }
        }
        return arrayList;
    }

    public OpenPGPDetachedSignatureProcessor setExceptionCallback(OpenPGPMessageProcessor.PGPExceptionCallback pGPExceptionCallback) {
        this.exceptionCallback = pGPExceptionCallback;
        return this;
    }
}

