/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.util.Date;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import shadow.org.bouncycastle.openpgp.api.OpenPGPDetachedSignatureGenerator;
import shadow.org.bouncycastle.openpgp.api.OpenPGPDetachedSignatureProcessor;
import shadow.org.bouncycastle.openpgp.api.OpenPGPImplementation;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKey;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKeyEditor;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKeyGenerator;
import shadow.org.bouncycastle.openpgp.api.OpenPGPKeyReader;
import shadow.org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import shadow.org.bouncycastle.openpgp.api.OpenPGPMessageProcessor;
import shadow.org.bouncycastle.openpgp.api.OpenPGPPolicy;

public abstract class OpenPGPApi {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;

    public OpenPGPApi(OpenPGPImplementation openPGPImplementation) {
        this(openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPApi(OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) {
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
    }

    public OpenPGPKeyReader readKeyOrCertificate() {
        return new OpenPGPKeyReader(this.implementation, this.policy);
    }

    public OpenPGPKeyGenerator generateKey() throws PGPException {
        return this.generateKey(6);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1) throws PGPException;

    public OpenPGPKeyGenerator generateKey(Date date) throws PGPException {
        return this.generateKey(6, date);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1, Date var2) throws PGPException;

    public OpenPGPKeyGenerator generateKey(Date date, boolean bl) throws PGPException {
        return this.generateKey(6, date, bl);
    }

    public abstract OpenPGPKeyGenerator generateKey(int var1, Date var2, boolean var3) throws PGPException;

    public OpenPGPMessageGenerator signAndOrEncryptMessage() {
        return new OpenPGPMessageGenerator(this.implementation, this.policy);
    }

    public OpenPGPDetachedSignatureGenerator createDetachedSignature() {
        return new OpenPGPDetachedSignatureGenerator(this.implementation, this.policy);
    }

    public OpenPGPMessageProcessor decryptAndOrVerifyMessage() {
        return new OpenPGPMessageProcessor(this.implementation, this.policy);
    }

    public OpenPGPDetachedSignatureProcessor verifyDetachedSignature() {
        return new OpenPGPDetachedSignatureProcessor(this.implementation, this.policy);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey openPGPKey) throws PGPException {
        return this.editKey(openPGPKey, (char[])null);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey openPGPKey, final char[] cArray) throws PGPException {
        return new OpenPGPKeyEditor(openPGPKey, new KeyPassphraseProvider(){
            final /* synthetic */ OpenPGPApi this$0;
            {
                this.this$0 = openPGPApi;
            }

            @Override
            public char[] getKeyPassword(OpenPGPKey.OpenPGPSecretKey openPGPSecretKey) {
                return cArray;
            }
        }, this.implementation, this.policy);
    }

    public OpenPGPKeyEditor editKey(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider) throws PGPException {
        return new OpenPGPKeyEditor(openPGPKey, keyPassphraseProvider, this.implementation, this.policy);
    }

    public OpenPGPImplementation getImplementation() {
        return this.implementation;
    }
}

