/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPKeyPair;
import shadow.org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;

public interface KeyPairGeneratorCallback {
    public PGPKeyPair generateFrom(PGPKeyPairGenerator var1) throws PGPException;

    public static class Util {
        public static KeyPairGeneratorCallback primaryKey() {
            return new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generatePrimaryKey();
                }
            };
        }

        public static KeyPairGeneratorCallback encryptionKey() {
            return new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateEncryptionSubkey();
                }
            };
        }

        public static KeyPairGeneratorCallback signingKey() {
            return new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateSigningSubkey();
                }
            };
        }
    }
}

