/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncDataPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import shadow.org.bouncycastle.openpgp.PGPEncryptedDataList;
import shadow.org.bouncycastle.openpgp.PGPException;

public enum EncryptedDataPacketType {
    SED,
    SEIPDv1,
    SEIPDv2,
    LIBREPGP_OED;


    public static EncryptedDataPacketType of(PGPEncryptedDataList pGPEncryptedDataList) throws PGPException {
        return EncryptedDataPacketType.of(pGPEncryptedDataList.getEncryptedData());
    }

    public static EncryptedDataPacketType of(InputStreamPacket inputStreamPacket) throws PGPException {
        if (inputStreamPacket instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)inputStreamPacket;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                return SEIPDv1;
            }
            if (symmetricEncIntegrityPacket.getVersion() == 2) {
                return SEIPDv2;
            }
            throw new UnsupportedPacketVersionException("Symmetrically-Encrypted Integrity-Protected Data Packet of unknown version encountered: " + symmetricEncIntegrityPacket.getVersion());
        }
        if (inputStreamPacket instanceof AEADEncDataPacket) {
            return LIBREPGP_OED;
        }
        if (inputStreamPacket instanceof SymmetricEncDataPacket) {
            return SED;
        }
        throw new PGPException("Unexpected packet type: " + inputStreamPacket.getClass().getName());
    }
}

