/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.InputStream;

public class DoubleBufferedInputStream<I extends InputStream>
extends InputStream {
    private static final int BUFFER_SIZE = 0x2000000;
    private byte[] buf1;
    private byte[] buf2;
    private int b1Pos;
    private int b1Max;
    private int b2Max;
    private final I in;
    private boolean closed = false;

    public DoubleBufferedInputStream(I i) {
        this(i, 0x2000000);
    }

    public DoubleBufferedInputStream(I i, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size cannot be zero nor negative.");
        }
        this.buf1 = new byte[n];
        this.buf2 = new byte[n];
        this.in = i;
        this.b1Pos = -1;
    }

    public I getInputStream() {
        return this.in;
    }

    private void fill() throws IOException {
        if (this.b1Pos == -1) {
            this.b1Max = ((InputStream)this.in).read(this.buf1);
            this.b2Max = ((InputStream)this.in).read(this.buf2);
            if (this.b2Max == -1) {
                this.close();
            }
            this.b1Pos = 0;
            return;
        }
        if (this.b1Max <= 0) {
            return;
        }
        if (this.b1Pos == this.b1Max) {
            byte[] byArray = this.buf1;
            this.buf1 = this.buf2;
            this.buf2 = byArray;
            this.b1Max = this.b2Max;
            this.b1Pos = 0;
            try {
                int n;
                this.b2Max = ((InputStream)this.in).read(this.buf2);
                if (this.b2Max != this.buf2.length && (n = ((InputStream)this.in).read()) != -1) {
                    this.buf2[this.b2Max++] = (byte)n;
                }
            }
            catch (IOException iOException) {
                this.b1Max = -1;
                this.b2Max = -1;
                this.close();
                throw iOException;
            }
            if (this.b2Max == -1) {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            ((InputStream)this.in).close();
        }
    }

    @Override
    public int read() throws IOException {
        this.fill();
        if (this.b1Max == -1) {
            this.close();
            return -1;
        }
        return this.buf1[this.b1Pos++];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.fill();
        if (this.b1Max == -1) {
            this.close();
            return -1;
        }
        int n3 = Math.min(this.b1Max - this.b1Pos, n2);
        System.arraycopy(this.buf1, this.b1Pos, byArray, n, n3);
        this.b1Pos += n3;
        return n3;
    }
}

