/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Date;
import shadow.org.bouncycastle.bcpg.MPInteger;
import shadow.org.bouncycastle.bcpg.OnePassSignaturePacket;
import shadow.org.bouncycastle.bcpg.SignaturePacket;
import shadow.org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPOnePassSignature;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSigner;
import shadow.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;

public class PGPV3SignatureGenerator
extends PGPDefaultSignatureGenerator {
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;

    public PGPV3SignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        super(3);
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (n == 255) {
            throw new PGPException("Illegal signature type 0xFF provided.");
        }
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException {
        long l = new Date().getTime() / 1000L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.sigType);
        byteArrayOutputStream.write((byte)(l >> 24));
        byteArrayOutputStream.write((byte)(l >> 16));
        byteArrayOutputStream.write((byte)(l >> 8));
        byteArrayOutputStream.write((byte)l);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.blockUpdate(byArray, 0, byArray.length);
        MPInteger[] mPIntegerArray = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] byArray2 = this.contentSigner.getDigest();
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1]};
        return new PGPSignature(new SignaturePacket(3, this.contentSigner.getType(), this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), l * 1000L, byArray3, mPIntegerArray));
    }
}

