/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import shadow.org.bouncycastle.openpgp.PGPDataValidationException;
import shadow.org.bouncycastle.openpgp.PGPEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPSessionKey;
import shadow.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import shadow.org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
            if (aEADEncDataPacket.getAlgorithm() != pGPSessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(aEADEncDataPacket, pGPSessionKey);
            InputStream inputStream = this.getInputStream();
            return pGPDataDecryptor.getInputStream(inputStream);
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(true, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                return this.getDataStream(true, pGPDataDecryptor);
            }
            if (symmetricEncIntegrityPacket.getVersion() == 2) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
                return pGPDataDecryptor.getInputStream(this.getInputStream());
            }
            throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + symmetricEncIntegrityPacket.getVersion());
        }
        PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(false, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
        return this.getDataStream(false, pGPDataDecryptor);
    }

    private InputStream getDataStream(boolean bl, PGPDataDecryptor pGPDataDecryptor) throws PGPException {
        try {
            InputStream inputStream = this.getInputStream();
            inputStream.mark(pGPDataDecryptor.getBlockSize() + 2);
            if (this.processSymmetricEncIntegrityPacketDataStream(bl, pGPDataDecryptor, inputStream)) {
                inputStream.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

