/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import shadow.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;

public class PGPSessionKeyEncryptedData
extends PGPSymmetricKeyEncryptedData {
    PGPSessionKeyEncryptedData(InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
    }

    @Override
    public int getAlgorithm() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
            return aEADEncDataPacket.getAlgorithm();
        }
        return -1;
    }

    @Override
    public int getVersion() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
            return aEADEncDataPacket.getVersion();
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
            return symmetricEncIntegrityPacket.getVersion();
        }
        return -1;
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        this.encStream = this.createDecryptionStream(sessionKeyDataDecryptorFactory, sessionKeyDataDecryptorFactory.getSessionKey());
        return this.encStream;
    }
}

