/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import shadow.org.bouncycastle.bcpg.BCPGKey;
import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class PGPPrivateKey {
    private long keyID;
    private PublicKeyPacket publicKeyPacket;
    private BCPGKey privateKeyDataPacket;

    public PGPPrivateKey(long l, PublicKeyPacket publicKeyPacket, BCPGKey bCPGKey) {
        this.keyID = l;
        this.publicKeyPacket = publicKeyPacket;
        this.privateKeyDataPacket = bCPGKey;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public KeyIdentifier getKeyIdentifier(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        byte[] byArray = keyFingerPrintCalculator.calculateFingerprint(this.publicKeyPacket);
        return new KeyIdentifier(byArray, PublicKeyPacket.getKeyID(this.publicKeyPacket, byArray));
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicKeyPacket;
    }

    public BCPGKey getPrivateKeyDataPacket() {
        return this.privateKeyDataPacket;
    }
}

