/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.bcpg.PublicSubkeyPacket;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPrivateKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class PGPKeyPair {
    protected PGPPublicKey pub;
    protected PGPPrivateKey priv;

    public PGPKeyPair(PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) {
        this.pub = pGPPublicKey;
        this.priv = pGPPrivateKey;
    }

    protected PGPKeyPair() {
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.getPublicKey().getKeyIdentifier();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }

    public PGPKeyPair asSubkey(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        if (this.pub.getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            return this;
        }
        PublicSubkeyPacket publicSubkeyPacket = new PublicSubkeyPacket(this.pub.getVersion(), this.pub.getAlgorithm(), this.pub.getCreationTime(), this.pub.getPublicKeyPacket().getKey());
        return new PGPKeyPair(new PGPPublicKey(publicSubkeyPacket, keyFingerPrintCalculator), new PGPPrivateKey(this.pub.getKeyID(), publicSubkeyPacket, this.priv.getPrivateKeyDataPacket()));
    }
}

