/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.Packet;
import shadow.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import shadow.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import shadow.org.bouncycastle.openpgp.PGPEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import shadow.org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import shadow.org.bouncycastle.openpgp.Util;
import shadow.org.bouncycastle.util.Iterable;

public class PGPEncryptedDataList
implements Iterable<PGPEncryptedData> {
    private static final Logger LOG = Logger.getLogger(PGPEncryptedDataList.class.getName());
    List<PGPEncryptedData> methods = new ArrayList<PGPEncryptedData>();
    InputStreamPacket data;

    public PGPEncryptedDataList(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 1, 3));
    }

    public PGPEncryptedDataList(InputStream inputStream) throws IOException {
        this(Util.createBCPGInputStream(inputStream, 1, 3));
    }

    public PGPEncryptedDataList(BCPGInputStream bCPGInputStream) throws IOException {
        ArrayList<Packet> arrayList = new ArrayList<Packet>();
        while (bCPGInputStream.nextPacketTag() == 1 || bCPGInputStream.nextPacketTag() == 3) {
            try {
                arrayList.add(bCPGInputStream.readPacket());
            }
            catch (UnsupportedPacketVersionException unsupportedPacketVersionException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown session packet: " + unsupportedPacketVersionException.getMessage());
            }
        }
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        for (int i = 0; i != arrayList.size(); ++i) {
            if (arrayList.get(i) instanceof SymmetricKeyEncSessionPacket) {
                this.methods.add(new PGPPBEEncryptedData((SymmetricKeyEncSessionPacket)arrayList.get(i), this.data));
                continue;
            }
            this.methods.add(new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)arrayList.get(i), this.data));
        }
    }

    public boolean isIntegrityProtected() {
        return this.data instanceof SymmetricEncIntegrityPacket;
    }

    public PGPEncryptedData get(int n) {
        return this.methods.get(n);
    }

    public InputStreamPacket getEncryptedData() {
        return this.data;
    }

    public int size() {
        return this.methods.size();
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Iterator<PGPEncryptedData> getEncryptedDataObjects() {
        return this.methods.iterator();
    }

    @Override
    public Iterator<PGPEncryptedData> iterator() {
        return this.getEncryptedDataObjects();
    }

    public PGPSessionKeyEncryptedData extractSessionKeyEncryptedData() {
        return new PGPSessionKeyEncryptedData(this.data);
    }
}

