/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.jcajce.provider.symmetric;

import shadow.org.bouncycastle.crypto.CipherKeyGenerator;
import shadow.org.bouncycastle.crypto.engines.HC128Engine;
import shadow.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import shadow.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import shadow.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import shadow.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import shadow.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class HC128 {
    private HC128() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "HC128 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new HC128Engine(), 16);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("HC128", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = HC128.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.HC128", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.HC128", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.HC128", PREFIX + "$AlgParams");
        }
    }
}

