/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.crypto.agreement.kdf;

import java.io.IOException;
import shadow.org.bouncycastle.asn1.ASN1Encodable;
import shadow.org.bouncycastle.asn1.ASN1EncodableVector;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.DERNull;
import shadow.org.bouncycastle.asn1.DEROctetString;
import shadow.org.bouncycastle.asn1.DERSequence;
import shadow.org.bouncycastle.asn1.DERTaggedObject;
import shadow.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shadow.org.bouncycastle.crypto.DataLengthException;
import shadow.org.bouncycastle.crypto.DerivationParameters;
import shadow.org.bouncycastle.crypto.Digest;
import shadow.org.bouncycastle.crypto.DigestDerivationFunction;
import shadow.org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import shadow.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import shadow.org.bouncycastle.crypto.params.KDFParameters;
import shadow.org.bouncycastle.util.Pack;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.algorithm = dHKDFParameters.getAlgorithm();
        this.keySize = dHKDFParameters.getKeySize();
        this.z = dHKDFParameters.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) throws DataLengthException, IllegalArgumentException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
        aSN1EncodableVector.add(new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector).getEncoded("DER")));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to initialise kdf: " + iOException.getMessage());
        }
        return this.kdf.generateBytes(byArray, n, n2);
    }
}

