/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.crypto.agreement;

import shadow.org.bouncycastle.crypto.CryptoServiceProperties;
import shadow.org.bouncycastle.crypto.CryptoServicePurpose;
import shadow.org.bouncycastle.crypto.constraints.ConstraintUtils;
import shadow.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import shadow.org.bouncycastle.crypto.params.DHKeyParameters;
import shadow.org.bouncycastle.crypto.params.ECKeyParameters;
import shadow.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.X448PrivateKeyParameters;

class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(String string, ECKeyParameters eCKeyParameters) {
        return new DefaultServiceProperties(string, ConstraintUtils.bitsOfSecurityFor(eCKeyParameters.getParameters().getCurve()), eCKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string, DHKeyParameters dHKeyParameters) {
        return new DefaultServiceProperties(string, ConstraintUtils.bitsOfSecurityFor(dHKeyParameters.getParameters().getP()), dHKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string, X448PrivateKeyParameters x448PrivateKeyParameters) {
        return new DefaultServiceProperties(string, 224, x448PrivateKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string, X25519PrivateKeyParameters x25519PrivateKeyParameters) {
        return new DefaultServiceProperties(string, 128, x25519PrivateKeyParameters, CryptoServicePurpose.AGREEMENT);
    }
}

