/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg.sig;

import shadow.org.bouncycastle.bcpg.FingerprintUtil;
import shadow.org.bouncycastle.bcpg.KeyIdentifier;
import shadow.org.bouncycastle.bcpg.SignatureSubpacket;
import shadow.org.bouncycastle.util.Arrays;

public class IssuerFingerprint
extends SignatureSubpacket {
    public IssuerFingerprint(boolean bl, boolean bl2, byte[] byArray) {
        super(33, bl, bl2, IssuerFingerprint.verifyData(byArray));
    }

    public IssuerFingerprint(boolean bl, int n, byte[] byArray) {
        super(33, bl, false, Arrays.prepend(byArray, (byte)n));
    }

    private static byte[] verifyData(byte[] byArray) {
        if (byArray.length < 1) {
            throw new IllegalArgumentException("Data too short. Expect at least one octet of key version.");
        }
        return byArray;
    }

    public int getKeyVersion() {
        return this.data[0] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange(this.data, 1, this.data.length);
    }

    public long getKeyID() {
        if (this.getKeyVersion() == 4) {
            return FingerprintUtil.keyIdFromV4Fingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 5) {
            return FingerprintUtil.keyIdFromLibrePgpFingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 6) {
            return FingerprintUtil.keyIdFromV6Fingerprint(this.getFingerprint());
        }
        return 0L;
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint());
    }
}

