/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.MalformedPacketException;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.bcpg.UserAttributeSubpacket;
import shadow.org.bouncycastle.bcpg.UserAttributeSubpacketTags;
import shadow.org.bouncycastle.bcpg.attr.ImageAttribute;

public class UserAttributeSubpacketInputStream
extends InputStream
implements UserAttributeSubpacketTags {
    InputStream in;
    private final int limit;

    public UserAttributeSubpacketInputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public UserAttributeSubpacketInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.limit = n;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > 0) {
            n3 = this.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            byArray[n] = (byte)n3;
            ++n;
            --n2;
        }
        while (n2 > 0) {
            n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public UserAttributeSubpacket readPacket() throws IOException {
        boolean[] blArray = new boolean[3];
        int n = StreamUtil.readBodyLen(this, blArray);
        if (blArray[StreamUtil.flag_eof]) {
            return null;
        }
        if (blArray[StreamUtil.flag_partial]) {
            throw new MalformedPacketException("unrecognised length reading user attribute sub packet");
        }
        if (n < 1) {
            throw new MalformedPacketException("Body length octet too small.");
        }
        if (n > this.limit) {
            throw new MalformedPacketException("Body length octet (" + n + ") exceeds limitations (" + this.limit + ").");
        }
        boolean bl = blArray[StreamUtil.flag_isLongLength];
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("unexpected EOF reading user attribute sub packet");
        }
        byte[] byArray = new byte[n - 1];
        this.readFully(byArray, 0, byArray.length);
        int n3 = n2;
        try {
            switch (n3) {
                case 1: {
                    return new ImageAttribute(bl, byArray);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPacketException("Malformed UserAttribute subpacket.", illegalArgumentException);
        }
        return new UserAttributeSubpacket(n3, bl, byArray);
    }
}

