/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.util.Arrays;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    static int flag_eof = 0;
    static int flag_isLongLength = 1;
    static int flag_partial = 2;

    StreamUtil() {
    }

    static int findLimit(InputStream inputStream) {
        if (inputStream instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream).available();
        }
        if (inputStream instanceof FileInputStream) {
            try {
                long l;
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                long l2 = l = fileChannel != null ? fileChannel.size() : Integer.MAX_VALUE;
                if (l < Integer.MAX_VALUE) {
                    return (int)l;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static void writeNewPacketLength(OutputStream outputStream, long l) throws IOException {
        if (l < 192L) {
            outputStream.write((byte)l);
        } else if (l <= 8383L) {
            outputStream.write((byte)(((l -= 192L) >> 8 & 0xFFL) + 192L));
            outputStream.write((byte)l);
        } else {
            outputStream.write(255);
            StreamUtil.writeBodyLen(outputStream, l);
        }
    }

    static void writeBodyLen(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >> 24));
        outputStream.write((byte)(l >> 16));
        outputStream.write((byte)(l >> 8));
        outputStream.write((byte)l);
    }

    static void writeKeyID(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        bCPGOutputStream.write((byte)(l >> 56));
        bCPGOutputStream.write((byte)(l >> 48));
        bCPGOutputStream.write((byte)(l >> 40));
        bCPGOutputStream.write((byte)(l >> 32));
        bCPGOutputStream.write((byte)(l >> 24));
        bCPGOutputStream.write((byte)(l >> 16));
        bCPGOutputStream.write((byte)(l >> 8));
        bCPGOutputStream.write((byte)l);
    }

    static long readKeyID(BCPGInputStream bCPGInputStream) throws IOException {
        long l = (long)bCPGInputStream.read() << 56;
        l |= (long)bCPGInputStream.read() << 48;
        l |= (long)bCPGInputStream.read() << 40;
        l |= (long)bCPGInputStream.read() << 32;
        l |= (long)bCPGInputStream.read() << 24;
        l |= (long)bCPGInputStream.read() << 16;
        return (l |= (long)bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
    }

    static void writeTime(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        StreamUtil.writeSeconds(bCPGOutputStream, l / 1000L);
    }

    static long readTime(BCPGInputStream bCPGInputStream) throws IOException {
        return StreamUtil.readSeconds(bCPGInputStream) * 1000L;
    }

    static void writeSeconds(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        StreamUtil.write4OctetLength(bCPGOutputStream, (int)l);
    }

    static long readSeconds(BCPGInputStream bCPGInputStream) throws IOException {
        return (long)StreamUtil.read4OctetLength(bCPGInputStream) & 0xFFFFFFFFL;
    }

    static void write2OctetLength(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    static int read2OctetLength(InputStream inputStream) throws IOException {
        return inputStream.read() << 8 | inputStream.read();
    }

    static void write4OctetLength(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24);
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    static int read4OctetLength(InputStream inputStream) throws IOException {
        return inputStream.read() << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
    }

    static int readBodyLen(InputStream inputStream, boolean[] blArray) throws IOException {
        Arrays.fill(blArray, false);
        int n = inputStream.read();
        int n2 = -1;
        if (n < 0) {
            blArray[StreamUtil.flag_eof] = true;
        }
        if (n < 192) {
            n2 = n;
        } else if (n <= 223) {
            n2 = (n - 192 << 8) + inputStream.read() + 192;
        } else if (n == 255) {
            blArray[StreamUtil.flag_isLongLength] = true;
            n2 = StreamUtil.read4OctetLength(inputStream);
        } else {
            blArray[StreamUtil.flag_partial] = true;
            n2 = 1 << (n & 0x1F);
        }
        return n2;
    }

    static void write8OctetLength(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l >> 56));
        outputStream.write((int)(l >> 48));
        outputStream.write((int)(l >> 40));
        outputStream.write((int)(l >> 32));
        outputStream.write((int)(l >> 24));
        outputStream.write((int)(l >> 16));
        outputStream.write((int)(l >> 8));
        outputStream.write((int)l);
    }

    static long read8OctetLength(InputStream inputStream) throws IOException {
        return (long)inputStream.read() << 56 | (long)inputStream.read() << 48 | (long)inputStream.read() << 40 | (long)inputStream.read() << 32 | (long)inputStream.read() << 24 | (long)inputStream.read() << 16 | (long)inputStream.read() << 8 | (long)inputStream.read();
    }
}

