/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.MalformedPacketException;
import shadow.org.bouncycastle.bcpg.SignatureSubpacket;
import shadow.org.bouncycastle.bcpg.SignatureSubpacketTags;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.bcpg.sig.EmbeddedSignature;
import shadow.org.bouncycastle.bcpg.sig.Exportable;
import shadow.org.bouncycastle.bcpg.sig.Features;
import shadow.org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import shadow.org.bouncycastle.bcpg.sig.IssuerFingerprint;
import shadow.org.bouncycastle.bcpg.sig.IssuerKeyID;
import shadow.org.bouncycastle.bcpg.sig.KeyExpirationTime;
import shadow.org.bouncycastle.bcpg.sig.KeyFlags;
import shadow.org.bouncycastle.bcpg.sig.LibrePGPPreferredEncryptionModes;
import shadow.org.bouncycastle.bcpg.sig.NotationData;
import shadow.org.bouncycastle.bcpg.sig.PolicyURI;
import shadow.org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import shadow.org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import shadow.org.bouncycastle.bcpg.sig.PreferredKeyServer;
import shadow.org.bouncycastle.bcpg.sig.PrimaryUserID;
import shadow.org.bouncycastle.bcpg.sig.RegularExpression;
import shadow.org.bouncycastle.bcpg.sig.Revocable;
import shadow.org.bouncycastle.bcpg.sig.RevocationKey;
import shadow.org.bouncycastle.bcpg.sig.RevocationReason;
import shadow.org.bouncycastle.bcpg.sig.SignatureCreationTime;
import shadow.org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import shadow.org.bouncycastle.bcpg.sig.SignatureTarget;
import shadow.org.bouncycastle.bcpg.sig.SignerUserID;
import shadow.org.bouncycastle.bcpg.sig.TrustSignature;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    private final InputStream in;
    private final int limit;

    public SignatureSubpacketInputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public SignatureSubpacketInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.limit = n;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        boolean[] blArray = new boolean[3];
        int n = StreamUtil.readBodyLen(this, blArray);
        if (blArray[StreamUtil.flag_eof]) {
            return null;
        }
        if (blArray[StreamUtil.flag_partial]) {
            throw new IOException("unexpected length header");
        }
        boolean bl = blArray[StreamUtil.flag_isLongLength];
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        if (n <= 0 || n > this.limit && n > 2048) {
            throw new EOFException("out of range data found in signature sub packet");
        }
        byte[] byArray = new byte[n - 1];
        int n3 = Streams.readFully(this.in, byArray);
        boolean bl2 = (n2 & 0x80) != 0;
        int n4 = n2 & 0x7F;
        if (n3 != byArray.length) {
            switch (n4) {
                case 2: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Creation Time");
                    break;
                }
                case 16: {
                    byArray = this.checkData(byArray, 8, n3, "Issuer");
                    break;
                }
                case 9: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        try {
            switch (n4) {
                case 2: {
                    return new SignatureCreationTime(bl2, bl, byArray);
                }
                case 32: {
                    return new EmbeddedSignature(bl2, bl, byArray);
                }
                case 9: {
                    return new KeyExpirationTime(bl2, bl, byArray);
                }
                case 3: {
                    return new SignatureExpirationTime(bl2, bl, byArray);
                }
                case 7: {
                    return new Revocable(bl2, bl, byArray);
                }
                case 4: {
                    return new Exportable(bl2, bl, byArray);
                }
                case 30: {
                    return new Features(bl2, bl, byArray);
                }
                case 16: {
                    return new IssuerKeyID(bl2, bl, byArray);
                }
                case 5: {
                    return new TrustSignature(bl2, bl, byArray);
                }
                case 11: 
                case 21: 
                case 22: {
                    return new PreferredAlgorithms(n4, bl2, bl, byArray);
                }
                case 34: {
                    return new LibrePGPPreferredEncryptionModes(bl2, bl, byArray);
                }
                case 39: {
                    return new PreferredAEADCiphersuites(bl2, bl, byArray);
                }
                case 24: {
                    return new PreferredKeyServer(bl2, bl, byArray);
                }
                case 27: {
                    return new KeyFlags(bl2, bl, byArray);
                }
                case 26: {
                    return new PolicyURI(bl2, bl, byArray);
                }
                case 25: {
                    return new PrimaryUserID(bl2, bl, byArray);
                }
                case 28: {
                    return new SignerUserID(bl2, bl, byArray);
                }
                case 20: {
                    return new NotationData(bl2, bl, byArray);
                }
                case 6: {
                    return new RegularExpression(bl2, bl, byArray);
                }
                case 29: {
                    return new RevocationReason(bl2, bl, byArray);
                }
                case 12: {
                    return new RevocationKey(bl2, bl, byArray);
                }
                case 31: {
                    return new SignatureTarget(bl2, bl, byArray);
                }
                case 33: {
                    return new IssuerFingerprint(bl2, bl, byArray);
                }
                case 35: {
                    return new IntendedRecipientFingerprint(bl2, bl, byArray);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPacketException("Malformed signature subpacket.", illegalArgumentException);
        }
        return new SignatureSubpacket(n4, bl2, bl, byArray);
    }

    private byte[] checkData(byte[] byArray, int n, int n2, String string) throws EOFException {
        if (n2 != n) {
            throw new EOFException("truncated " + string + " subpacket data.");
        }
        return Arrays.copyOfRange(byArray, 0, n);
    }
}

