/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.BCPGKey;
import shadow.org.bouncycastle.bcpg.BCPGObject;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.bcpg.MPInteger;

public class RSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger n;
    MPInteger e;

    public RSAPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.n = new MPInteger(bCPGInputStream);
        this.e = new MPInteger(bCPGInputStream);
    }

    public RSAPublicBCPGKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n = new MPInteger(bigInteger);
        this.e = new MPInteger(bigInteger2);
    }

    public BigInteger getPublicExponent() {
        return this.e.getValue();
    }

    public BigInteger getModulus() {
        return this.n.getValue();
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writeObject(this.n);
        bCPGOutputStream.writeObject(this.e);
    }
}

