/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.bcpg.ContainedPacket;
import shadow.org.bouncycastle.bcpg.FingerprintUtil;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.io.Streams;

public class OnePassSignaturePacket
extends ContainedPacket {
    public static final int VERSION_3 = 3;
    public static final int VERSION_6 = 6;
    private final int version;
    private final int sigType;
    private final int hashAlgorithm;
    private final int keyAlgorithm;
    private final long keyID;
    private final byte[] fingerprint;
    private final byte[] salt;
    private final int isContaining;

    OnePassSignaturePacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    OnePassSignaturePacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(4, bl);
        this.version = bCPGInputStream.read();
        this.sigType = bCPGInputStream.read();
        this.hashAlgorithm = bCPGInputStream.read();
        this.keyAlgorithm = bCPGInputStream.read();
        if (this.version == 3) {
            this.keyID = StreamUtil.readKeyID(bCPGInputStream);
            this.fingerprint = null;
            this.salt = null;
        } else if (this.version == 6) {
            int n = bCPGInputStream.read();
            if (n < 0) {
                throw new IOException("Version 6 OPS packet has invalid salt length.");
            }
            this.salt = new byte[n];
            bCPGInputStream.readFully(this.salt);
            this.fingerprint = new byte[32];
            bCPGInputStream.readFully(this.fingerprint);
            this.keyID = FingerprintUtil.keyIdFromV6Fingerprint(this.fingerprint);
        } else {
            Streams.drain(bCPGInputStream);
            throw new UnsupportedPacketVersionException("Unsupported OnePassSignature packet version encountered: " + this.version);
        }
        this.isContaining = bCPGInputStream.read();
    }

    public OnePassSignaturePacket(int n, int n2, int n3, long l, boolean bl) {
        super(4);
        this.version = 3;
        this.sigType = n;
        this.hashAlgorithm = n2;
        this.keyAlgorithm = n3;
        this.keyID = l;
        this.fingerprint = null;
        this.salt = null;
        this.isContaining = bl ? 0 : 1;
    }

    public OnePassSignaturePacket(int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean bl) {
        super(4);
        this.version = 6;
        this.sigType = n;
        this.hashAlgorithm = n2;
        this.keyAlgorithm = n3;
        this.salt = byArray;
        this.fingerprint = byArray2;
        this.isContaining = bl ? 0 : 1;
        this.keyID = FingerprintUtil.keyIdFromV6Fingerprint(byArray2);
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.sigType;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }

    public boolean isContaining() {
        return this.isContaining == 1;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        bCPGOutputStream2.write(this.sigType);
        bCPGOutputStream2.write(this.hashAlgorithm);
        bCPGOutputStream2.write(this.keyAlgorithm);
        if (this.version == 3) {
            StreamUtil.writeKeyID(bCPGOutputStream2, this.keyID);
        } else if (this.version == 6) {
            bCPGOutputStream2.write(this.salt.length);
            bCPGOutputStream2.write(this.salt);
            bCPGOutputStream2.write(this.fingerprint);
        }
        bCPGOutputStream2.write(this.isContaining);
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 4, byteArrayOutputStream.toByteArray());
    }
}

