/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.BCPGObject;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.util.BigIntegers;

public class MPInteger
extends BCPGObject {
    private final BigInteger value;

    public MPInteger(BCPGInputStream bCPGInputStream) throws IOException {
        boolean bl = false;
        this.value = MPInteger.readMPI(bCPGInputStream, bl);
    }

    public MPInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = bigInteger;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        StreamUtil.write2OctetLength(bCPGOutputStream, this.value.bitLength());
        BigIntegers.writeUnsignedByteArray(bCPGOutputStream, this.value);
    }

    private static BigInteger readMPI(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        int n = StreamUtil.read2OctetLength(bCPGInputStream);
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        bCPGInputStream.readFully(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bl && bigInteger.bitLength() != n) {
            throw new IOException("malformed MPI");
        }
        return bigInteger;
    }
}

