/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.IOException;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.InputStreamPacket;
import shadow.org.bouncycastle.bcpg.MalformedPacketException;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.Strings;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    LiteralDataPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(bCPGInputStream, 11, bl);
        this.format = bCPGInputStream.read();
        int n = bCPGInputStream.read();
        if (n < 0) {
            throw new MalformedPacketException("File name size cannot be negative.");
        }
        this.fileName = new byte[n];
        for (int i = 0; i != this.fileName.length; ++i) {
            int n2 = bCPGInputStream.read();
            if (n2 < 0) {
                throw new IOException("literal data truncated in header");
            }
            this.fileName[i] = (byte)n2;
        }
        this.modDate = StreamUtil.readTime(bCPGInputStream);
        if (this.modDate < 0L) {
            throw new IOException("literal data truncated in header");
        }
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone(this.fileName);
    }
}

