/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import shadow.org.bouncycastle.bcpg.BCPGInputStream;
import shadow.org.bouncycastle.bcpg.BCPGKey;
import shadow.org.bouncycastle.bcpg.BCPGObject;
import shadow.org.bouncycastle.bcpg.BCPGOutputStream;
import shadow.org.bouncycastle.bcpg.MPInteger;

public class ElGamalPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger p;
    MPInteger g;
    MPInteger y;

    public ElGamalPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.p = new MPInteger(bCPGInputStream);
        this.g = new MPInteger(bCPGInputStream);
        this.y = new MPInteger(bCPGInputStream);
    }

    public ElGamalPublicBCPGKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new MPInteger(bigInteger);
        this.g = new MPInteger(bigInteger2);
        this.y = new MPInteger(bigInteger3);
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getY() {
        return this.y.getValue();
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writeObject(this.p);
        bCPGOutputStream.writeObject(this.g);
        bCPGOutputStream.writeObject(this.y);
    }
}

