/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.bcpg;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.bcpg.AEADEncDataPacket;
import shadow.org.bouncycastle.bcpg.CompressedDataPacket;
import shadow.org.bouncycastle.bcpg.ExperimentalPacket;
import shadow.org.bouncycastle.bcpg.LiteralDataPacket;
import shadow.org.bouncycastle.bcpg.MarkerPacket;
import shadow.org.bouncycastle.bcpg.ModDetectionCodePacket;
import shadow.org.bouncycastle.bcpg.OnePassSignaturePacket;
import shadow.org.bouncycastle.bcpg.Packet;
import shadow.org.bouncycastle.bcpg.PacketTags;
import shadow.org.bouncycastle.bcpg.PaddingPacket;
import shadow.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import shadow.org.bouncycastle.bcpg.PublicKeyPacket;
import shadow.org.bouncycastle.bcpg.PublicSubkeyPacket;
import shadow.org.bouncycastle.bcpg.ReservedPacket;
import shadow.org.bouncycastle.bcpg.SecretKeyPacket;
import shadow.org.bouncycastle.bcpg.SecretSubkeyPacket;
import shadow.org.bouncycastle.bcpg.SignaturePacket;
import shadow.org.bouncycastle.bcpg.StreamUtil;
import shadow.org.bouncycastle.bcpg.SymmetricEncDataPacket;
import shadow.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import shadow.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import shadow.org.bouncycastle.bcpg.TrustPacket;
import shadow.org.bouncycastle.bcpg.UnknownPacket;
import shadow.org.bouncycastle.bcpg.UserAttributePacket;
import shadow.org.bouncycastle.bcpg.UserIDPacket;
import shadow.org.bouncycastle.util.io.Streams;

public class BCPGInputStream
extends InputStream
implements PacketTags {
    InputStream in;
    boolean next = false;
    int nextB;
    boolean mNext = false;
    int mNextB;

    public static BCPGInputStream wrap(InputStream inputStream) {
        if (inputStream instanceof BCPGInputStream) {
            return (BCPGInputStream)inputStream;
        }
        return new BCPGInputStream(inputStream);
    }

    public BCPGInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int n) {
        this.mNext = this.next;
        this.mNextB = this.nextB;
        this.in.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.next = this.mNext;
        this.nextB = this.mNextB;
        this.in.reset();
    }

    @Override
    public int read() throws IOException {
        if (this.next) {
            this.next = false;
            return this.nextB;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (!this.next) {
            return this.in.read(byArray, n, n2);
        }
        if (this.nextB < 0) {
            return -1;
        }
        byArray[n] = (byte)this.nextB;
        this.next = false;
        return 1;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (Streams.readFully(this, byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public byte[] readAll() throws IOException {
        return Streams.readAll(this);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public int nextPacketTag() throws IOException {
        if (!this.next) {
            try {
                this.nextB = this.read();
            }
            catch (EOFException eOFException) {
                this.nextB = -1;
            }
            this.next = true;
        }
        if (this.nextB < 0) {
            return this.nextB;
        }
        int n = this.nextB & 0x3F;
        if ((this.nextB & 0x40) == 0) {
            n >>= 2;
        }
        return n;
    }

    public Packet readPacket() throws IOException {
        Object object;
        int n = this.read();
        if (n < 0) {
            return null;
        }
        if ((n & 0x80) == 0) {
            throw new IOException("invalid header encountered");
        }
        boolean bl = (n & 0x40) != 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (bl) {
            n2 = n & 0x3F;
            object = new boolean[3];
            n3 = StreamUtil.readBodyLen(this, object);
            bl2 = object[StreamUtil.flag_partial];
        } else {
            int n4 = n & 3;
            n2 = (n & 0x3F) >> 2;
            switch (n4) {
                case 0: {
                    n3 = this.read();
                    break;
                }
                case 1: {
                    n3 = StreamUtil.read2OctetLength(this);
                    break;
                }
                case 2: {
                    n3 = StreamUtil.read4OctetLength(this);
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IOException("unknown length type encountered");
                }
            }
        }
        if (n3 == 0 && bl2) {
            object = this;
        } else {
            PartialInputStream partialInputStream = new PartialInputStream(this.in, bl2, n3);
            object = new BCPGInputStream(new BufferedInputStream(partialInputStream));
        }
        switch (n2) {
            case 0: {
                return new ReservedPacket((BCPGInputStream)object, bl);
            }
            case 1: {
                return new PublicKeyEncSessionPacket((BCPGInputStream)object, bl);
            }
            case 2: {
                return new SignaturePacket((BCPGInputStream)object, bl);
            }
            case 3: {
                return new SymmetricKeyEncSessionPacket((BCPGInputStream)object, bl);
            }
            case 4: {
                return new OnePassSignaturePacket((BCPGInputStream)object, bl);
            }
            case 5: {
                return new SecretKeyPacket((BCPGInputStream)object, bl);
            }
            case 6: {
                return new PublicKeyPacket((BCPGInputStream)object, bl);
            }
            case 7: {
                return new SecretSubkeyPacket((BCPGInputStream)object, bl);
            }
            case 8: {
                return new CompressedDataPacket((BCPGInputStream)object, bl);
            }
            case 9: {
                return new SymmetricEncDataPacket((BCPGInputStream)object, bl);
            }
            case 10: {
                return new MarkerPacket((BCPGInputStream)object, bl);
            }
            case 11: {
                return new LiteralDataPacket((BCPGInputStream)object, bl);
            }
            case 12: {
                return new TrustPacket((BCPGInputStream)object, bl);
            }
            case 13: {
                return new UserIDPacket((BCPGInputStream)object, bl);
            }
            case 17: {
                return new UserAttributePacket((BCPGInputStream)object, bl);
            }
            case 14: {
                return new PublicSubkeyPacket((BCPGInputStream)object, bl);
            }
            case 18: {
                return new SymmetricEncIntegrityPacket((BCPGInputStream)object, bl);
            }
            case 19: {
                return new ModDetectionCodePacket((BCPGInputStream)object, bl);
            }
            case 20: {
                return new AEADEncDataPacket((BCPGInputStream)object, bl);
            }
            case 21: {
                return new PaddingPacket((BCPGInputStream)object, bl);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return new ExperimentalPacket(n2, (BCPGInputStream)object, bl);
            }
        }
        return new UnknownPacket(n2, (BCPGInputStream)object, bl);
    }

    public int skipMarkerPackets() throws IOException {
        return this.skipMarkerAndPaddingPackets();
    }

    public int skipMarkerAndPaddingPackets() throws IOException {
        int n;
        while ((n = this.nextPacketTag()) == 10 || n == 21) {
            this.readPacket();
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static class PartialInputStream
    extends InputStream {
        private final InputStream in;
        private boolean partial;
        private int dataLength;

        PartialInputStream(InputStream inputStream, boolean bl, int n) {
            this.in = inputStream;
            this.partial = bl;
            this.dataLength = n;
        }

        @Override
        public int available() throws IOException {
            int n = this.in.available();
            if (n <= this.dataLength || this.dataLength < 0) {
                return n;
            }
            if (this.partial && this.dataLength == 0) {
                return 1;
            }
            return this.dataLength;
        }

        private int loadDataLength() throws IOException {
            boolean[] blArray = new boolean[3];
            this.dataLength = StreamUtil.readBodyLen(this.in, blArray);
            if (blArray[StreamUtil.flag_eof]) {
                return -1;
            }
            this.partial = blArray[StreamUtil.flag_partial];
            return this.dataLength;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int n3 = this.dataLength > n2 || this.dataLength < 0 ? n2 : this.dataLength;
                if ((n3 = this.in.read(byArray, n, n3)) < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                this.dataLength -= n3;
                if (this.partial && this.dataLength == 0) {
                    this.loadDataLength();
                }
                return n3;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }

        @Override
        public int read() throws IOException {
            do {
                if (this.dataLength == 0) continue;
                int n = this.in.read();
                if (n < 0) {
                    throw new EOFException("premature end of stream in PartialInputStream");
                }
                --this.dataLength;
                if (this.partial && this.dataLength == 0) {
                    this.loadDataLength();
                }
                return n;
            } while (this.partial && this.loadDataLength() >= 0);
            return -1;
        }
    }
}

