/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.asn1.x9;

import shadow.org.bouncycastle.asn1.ASN1Object;
import shadow.org.bouncycastle.asn1.ASN1Primitive;
import shadow.org.bouncycastle.asn1.DEROctetString;
import shadow.org.bouncycastle.asn1.x9.X9IntegerConverter;
import shadow.org.bouncycastle.math.ec.ECFieldElement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class X9FieldElement
extends ASN1Object {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement eCFieldElement) {
        this.f = eCFieldElement;
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        int n = converter.getByteLength(this.f);
        byte[] byArray = converter.integerToBytes(this.f.toBigInteger(), n);
        return new DEROctetString(byArray);
    }
}

