/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.asn1.pkcs;

import shadow.org.bouncycastle.asn1.ASN1Encodable;
import shadow.org.bouncycastle.asn1.ASN1Object;
import shadow.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shadow.org.bouncycastle.asn1.ASN1Primitive;
import shadow.org.bouncycastle.asn1.ASN1Sequence;
import shadow.org.bouncycastle.asn1.ASN1TaggedObject;
import shadow.org.bouncycastle.asn1.DERSequence;
import shadow.org.bouncycastle.asn1.DERTaggedObject;

public class CRLBag
extends ASN1Object {
    private ASN1ObjectIdentifier crlId;
    private ASN1Encodable crlValue;

    private CRLBag(ASN1Sequence aSN1Sequence) {
        this.crlId = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.crlValue = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1)).getExplicitBaseObject();
    }

    public static CRLBag getInstance(Object object) {
        if (object instanceof CRLBag) {
            return (CRLBag)object;
        }
        if (object != null) {
            return new CRLBag(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CRLBag(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.crlId = aSN1ObjectIdentifier;
        this.crlValue = aSN1Encodable;
    }

    public ASN1ObjectIdentifier getCrlId() {
        return this.crlId;
    }

    public ASN1Encodable getCrlValue() {
        return this.crlValue;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.crlId, new DERTaggedObject(0, this.crlValue));
    }
}

