/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.asn1.cms;

import shadow.org.bouncycastle.asn1.ASN1EncodableVector;
import shadow.org.bouncycastle.asn1.ASN1Object;
import shadow.org.bouncycastle.asn1.ASN1Primitive;
import shadow.org.bouncycastle.asn1.ASN1Sequence;
import shadow.org.bouncycastle.asn1.DERSequence;
import shadow.org.bouncycastle.asn1.cms.ContentInfo;
import shadow.org.bouncycastle.asn1.x509.CertificateList;

public class TimeStampAndCRL
extends ASN1Object {
    private ContentInfo timeStamp;
    private CertificateList crl;

    public TimeStampAndCRL(ContentInfo contentInfo) {
        this(contentInfo, null);
    }

    public TimeStampAndCRL(ContentInfo contentInfo, CertificateList certificateList) {
        this.timeStamp = contentInfo;
        this.crl = certificateList;
    }

    private TimeStampAndCRL(ASN1Sequence aSN1Sequence) {
        this.timeStamp = ContentInfo.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() == 2) {
            this.crl = CertificateList.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public static TimeStampAndCRL getInstance(Object object) {
        if (object instanceof TimeStampAndCRL) {
            return (TimeStampAndCRL)object;
        }
        if (object != null) {
            return new TimeStampAndCRL(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ContentInfo getTimeStampToken() {
        return this.timeStamp;
    }

    public CertificateList getCertificateList() {
        return this.crl;
    }

    public CertificateList getCRL() {
        return this.crl;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.timeStamp);
        if (this.crl != null) {
            aSN1EncodableVector.add(this.crl);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

