/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import shadow.org.bouncycastle.apache.bzip2.BZip2Constants;
import shadow.org.bouncycastle.apache.bzip2.CRC;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.Integers;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    static final short[] R_NUMS = new short[]{619, 720, 127, 481, 931, 816, 813, 233, 566, 247, 985, 724, 205, 454, 863, 491, 741, 242, 949, 214, 733, 859, 335, 708, 621, 574, 73, 654, 730, 472, 419, 436, 278, 496, 867, 210, 399, 680, 480, 51, 878, 465, 811, 169, 869, 675, 611, 697, 867, 561, 862, 687, 507, 283, 482, 129, 807, 591, 733, 623, 150, 238, 59, 379, 684, 877, 625, 169, 643, 105, 170, 607, 520, 932, 727, 476, 693, 425, 174, 647, 73, 122, 335, 530, 442, 853, 695, 249, 445, 515, 909, 545, 703, 919, 874, 474, 882, 500, 594, 612, 641, 801, 220, 162, 819, 984, 589, 513, 495, 799, 161, 604, 958, 533, 221, 400, 386, 867, 600, 782, 382, 596, 414, 171, 516, 375, 682, 485, 911, 276, 98, 553, 163, 354, 666, 933, 424, 341, 533, 870, 227, 730, 475, 186, 263, 647, 537, 686, 600, 224, 469, 68, 770, 919, 190, 373, 294, 822, 808, 206, 184, 943, 795, 384, 383, 461, 404, 758, 839, 887, 715, 67, 618, 276, 204, 918, 873, 777, 604, 560, 951, 160, 578, 722, 79, 804, 96, 409, 713, 940, 652, 934, 970, 447, 318, 353, 859, 672, 112, 785, 645, 863, 803, 350, 139, 93, 354, 99, 820, 908, 609, 772, 154, 274, 580, 184, 79, 626, 630, 742, 653, 282, 762, 623, 680, 81, 927, 626, 789, 125, 411, 521, 938, 300, 821, 78, 343, 175, 128, 250, 170, 774, 972, 275, 999, 639, 495, 78, 352, 126, 857, 956, 358, 619, 580, 124, 737, 594, 701, 612, 669, 112, 134, 694, 363, 992, 809, 743, 168, 974, 944, 375, 748, 52, 600, 747, 642, 182, 862, 81, 344, 805, 988, 739, 511, 655, 814, 334, 249, 515, 897, 955, 664, 981, 649, 113, 974, 459, 893, 228, 433, 837, 553, 268, 926, 240, 102, 654, 459, 51, 686, 754, 806, 760, 493, 403, 415, 394, 687, 700, 946, 670, 656, 610, 738, 392, 760, 799, 887, 653, 978, 321, 576, 617, 626, 502, 894, 679, 243, 440, 680, 879, 194, 572, 640, 724, 926, 56, 204, 700, 707, 151, 457, 449, 797, 195, 791, 558, 945, 679, 297, 59, 87, 824, 713, 663, 412, 693, 342, 606, 134, 108, 571, 364, 631, 212, 174, 643, 304, 329, 343, 97, 430, 751, 497, 314, 983, 374, 822, 928, 140, 206, 73, 263, 980, 736, 876, 478, 430, 305, 170, 514, 364, 692, 829, 82, 855, 953, 676, 246, 369, 970, 294, 750, 807, 827, 150, 790, 288, 923, 804, 378, 215, 828, 592, 281, 565, 555, 710, 82, 896, 831, 547, 261, 524, 462, 293, 465, 502, 56, 661, 821, 976, 991, 658, 869, 905, 758, 745, 193, 768, 550, 608, 933, 378, 286, 215, 979, 792, 961, 61, 688, 793, 644, 986, 403, 106, 366, 905, 644, 372, 567, 466, 434, 645, 210, 389, 550, 919, 135, 780, 773, 635, 389, 707, 100, 626, 958, 165, 504, 920, 176, 193, 713, 857, 265, 203, 50, 668, 108, 645, 990, 626, 197, 510, 357, 358, 850, 858, 364, 936, 638};
    private static final int[] INCS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean finished;
    int count;
    int origPtr;
    private final int blockSize100k;
    private final int allowableBlockSize;
    boolean blockRandomised;
    private final Vector blocksortStack = new Vector();
    int bsBuff;
    int bsLivePos;
    private final CRC blockCRC = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private byte[] selectors = new byte[18002];
    private byte[] blockBytes = null;
    private short[] quadrantShorts = null;
    private int[] zptr = null;
    private int[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentByte = -1;
    private int runLength = 0;
    private int streamCRC;
    boolean closed = false;
    private OutputStream bsStream;

    protected static void hbMakeCodeLengths(byte[] byArray, int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n3 = 1; n3 <= n; ++n3) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n8 >= 260) {
                throw new IllegalStateException();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = nArray4[n11] = ++n7;
                nArray3[n7] = (nArray3[n9] & 0xFFFFFF00) + (nArray3[n11] & 0xFFFFFF00) | 1 + ((nArray3[n9] & 0xFF) > (nArray3[n11] & 0xFF) ? nArray3[n9] & 0xFF : nArray3[n11] & 0xFF);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                n6 = 0;
                n5 = 0;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            if (n7 >= 516) {
                throw new IllegalStateException();
            }
            n6 = 0;
            for (n3 = 1; n3 <= n; ++n3) {
                n4 = 0;
                int n12 = n3;
                while (nArray4[n12] >= 0) {
                    n12 = nArray4[n12];
                    ++n4;
                }
                byArray[n3 - 1] = (byte)n4;
                n6 |= n2 - n4;
            }
            if (n6 >= 0) break;
            n3 = 1;
            while (true) {
                if (n3 > n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        outputStream.write(66);
        outputStream.write(90);
        this.bsStream = outputStream;
        this.bsBuff = 0;
        this.bsLivePos = 32;
        this.workFactor = 50;
        if (n > 9) {
            n = 9;
        } else if (n < 1) {
            n = 1;
        }
        this.blockSize100k = n;
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
        int n2 = 100000 * this.blockSize100k;
        this.blockBytes = new byte[n2 + 1 + 20];
        this.quadrantShorts = new short[n2 + 1 + 20];
        this.zptr = new int[n2];
        this.ftab = new int[65537];
        this.szptr = this.zptr;
        outputStream.write(104);
        outputStream.write(48 + this.blockSize100k);
        this.streamCRC = 0;
        this.initBlock();
    }

    @Override
    public void write(int n) throws IOException {
        int n2 = n & 0xFF;
        if (this.currentByte == n2) {
            if (++this.runLength > 254) {
                this.writeRun();
                this.currentByte = -1;
                this.runLength = 0;
            }
            return;
        }
        if (this.currentByte >= 0) {
            this.writeRun();
        }
        this.currentByte = n2;
        this.runLength = 1;
    }

    private void writeRun() throws IOException {
        if (this.count > this.allowableBlockSize) {
            this.endBlock();
            this.initBlock();
        }
        this.inUse[this.currentByte] = true;
        switch (this.runLength) {
            case 1: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                break;
            }
            case 2: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                break;
            }
            case 3: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                this.blockCRC.update(this.currentByte);
                break;
            }
            default: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)(this.runLength - 4);
                this.inUse[this.runLength - 4] = true;
                this.blockCRC.updateRun(this.currentByte, this.runLength);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentByte = -1;
        if (this.count > 0) {
            this.endBlock();
        }
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initBlock() {
        this.blockCRC.initialise();
        this.count = 0;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
    }

    private void endBlock() throws IOException {
        int n = this.blockCRC.getFinal();
        this.streamCRC = Integers.rotateLeft(this.streamCRC, 1) ^ n;
        this.doReversibleTransformation();
        this.bsPutLong48(54156738319193L);
        this.bsPutInt32(n);
        this.bsPutBit(this.blockRandomised ? 1 : 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutLong48(25779555029136L);
        this.bsPutInt32(this.streamCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if ((byArray[j] & 0xFF) != i) continue;
                nArray[j] = n4++;
            }
            n4 <<= 1;
        }
    }

    private void bsFinishedWithStream() throws IOException {
        if (this.bsLivePos < 32) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff = 0;
            this.bsLivePos = 32;
        }
    }

    private void bsPutBit(int n) throws IOException {
        --this.bsLivePos;
        this.bsBuff |= n << this.bsLivePos;
        if (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutBits(int n, int n2) throws IOException {
        this.bsLivePos -= n;
        this.bsBuff |= n2 << this.bsLivePos;
        while (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutBitsSmall(int n, int n2) throws IOException {
        this.bsLivePos -= n;
        this.bsBuff |= n2 << this.bsLivePos;
        if (this.bsLivePos <= 24) {
            this.bsStream.write(this.bsBuff >>> 24);
            this.bsBuff <<= 8;
            this.bsLivePos += 8;
        }
    }

    private void bsPutInt32(int n) throws IOException {
        this.bsPutBits(16, n >>> 16);
        this.bsPutBits(16, n & 0xFFFF);
    }

    private void bsPutLong48(long l) throws IOException {
        this.bsPutBits(24, (int)(l >>> 24) & 0xFFFFFF);
        this.bsPutBits(24, (int)l & 0xFFFFFF);
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        byte[] byArray;
        int n3;
        Object[] objectArray2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.nInUse + 2;
        if (this.nMTF <= 0) {
            throw new IllegalStateException();
        }
        int n9 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        byte[][] byArray2 = new byte[n9][n8];
        for (n7 = 0; n7 < n9; ++n7) {
            Arrays.fill(byArray2[n7], (byte)15);
        }
        int n10 = n9;
        int n11 = this.nMTF;
        int n12 = -1;
        while (n10 > 0) {
            n6 = n12 + 1;
            n5 = n11 / n10;
            for (n4 = 0; n4 < n5 && n12 < n8 - 1; n4 += this.mtfFreq[++n12]) {
            }
            if (n12 > n6 && n10 != n9 && n10 != 1 && (n9 - n10) % 2 == 1) {
                n4 -= this.mtfFreq[n12];
                --n12;
            }
            objectArray2 = byArray2[n10 - 1];
            for (n3 = 0; n3 < n8; ++n3) {
                objectArray2[n3] = n3 >= n6 && n3 <= n12 ? 0 : 15;
            }
            --n10;
            n11 -= n4;
        }
        int[][] nArray = new int[6][258];
        int[] nArray2 = new int[6];
        short[] sArray = new short[6];
        n6 = 0;
        for (int i = 0; i < 4; ++i) {
            for (n7 = 0; n7 < n9; ++n7) {
                nArray2[n7] = 0;
                int[] nArray3 = nArray[n7];
                for (n3 = 0; n3 < n8; ++n3) {
                    nArray3[n3] = 0;
                }
            }
            n6 = 0;
            n4 = 0;
            while (n4 < this.nMTF) {
                n5 = Math.min(n4 + 50 - 1, this.nMTF - 1);
                if (n9 == 6) {
                    objectArray2 = byArray2[0];
                    byArray = byArray2[1];
                    byte[] byArray3 = byArray2[2];
                    byte[] byArray4 = byArray2[3];
                    objectArray = byArray2[4];
                    byte[] byArray5 = byArray2[5];
                    short s = 0;
                    short s2 = 0;
                    short s3 = 0;
                    short s4 = 0;
                    short s5 = 0;
                    short s6 = 0;
                    for (n2 = n4; n2 <= n5; ++n2) {
                        int n13 = this.szptr[n2];
                        s = (short)(s + (objectArray2[n13] & 0xFF));
                        s2 = (short)(s2 + (byArray[n13] & 0xFF));
                        s3 = (short)(s3 + (byArray3[n13] & 0xFF));
                        s4 = (short)(s4 + (byArray4[n13] & 0xFF));
                        s5 = (short)(s5 + (objectArray[n13] & 0xFF));
                        s6 = (short)(s6 + (byArray5[n13] & 0xFF));
                    }
                    sArray[0] = s;
                    sArray[1] = s2;
                    sArray[2] = s3;
                    sArray[3] = s4;
                    sArray[4] = s5;
                    sArray[5] = s6;
                } else {
                    for (n7 = 0; n7 < n9; ++n7) {
                        sArray[n7] = 0;
                    }
                    for (n2 = n4; n2 <= n5; ++n2) {
                        int n14 = this.szptr[n2];
                        for (n7 = 0; n7 < n9; ++n7) {
                            int n15 = n7;
                            sArray[n15] = (short)(sArray[n15] + (byArray2[n7][n14] & 0xFF));
                        }
                    }
                }
                short s = sArray[0];
                int n16 = 0;
                for (n7 = 1; n7 < n9; ++n7) {
                    short s7 = sArray[n7];
                    if (s7 >= s) continue;
                    s = s7;
                    n16 = n7;
                }
                int n17 = n16;
                nArray2[n17] = nArray2[n17] + 1;
                this.selectors[n6] = (byte)n16;
                ++n6;
                objectArray2 = nArray[n16];
                for (n2 = n4; n2 <= n5; ++n2) {
                    int n18 = this.szptr[n2];
                    objectArray2[n18] = objectArray2[n18] + 1;
                }
                n4 = n5 + 1;
            }
            for (n7 = 0; n7 < n9; ++n7) {
                CBZip2OutputStream.hbMakeCodeLengths(byArray2[n7], nArray[n7], n8, 17);
            }
        }
        if (n9 >= 8 || n9 > 6) {
            throw new IllegalStateException();
        }
        if (n6 >= 32768 || n6 > 18002) {
            throw new IllegalStateException();
        }
        int[][] nArray4 = new int[n9][n8];
        for (n7 = 0; n7 < n9; ++n7) {
            n5 = 0;
            int n19 = 32;
            byArray = byArray2[n7];
            for (n2 = 0; n2 < n8; ++n2) {
                int n20 = byArray[n2] & 0xFF;
                n5 = Math.max(n5, n20);
                n19 = Math.min(n19, n20);
            }
            if (n19 < 1 | n5 > 17) {
                throw new IllegalStateException();
            }
            this.hbAssignCodes(nArray4[n7], byArray, n19, n5, n8);
        }
        boolean[] blArray = new boolean[16];
        block17: for (n2 = 0; n2 < 16; ++n2) {
            blArray[n2] = false;
            int n21 = n2 * 16;
            for (n = 0; n < 16; ++n) {
                if (!this.inUse[n21 + n]) continue;
                blArray[n2] = true;
                continue block17;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            this.bsPutBit(blArray[n2] ? 1 : 0);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            int n22 = n2 * 16;
            for (n = 0; n < 16; ++n) {
                this.bsPutBit(this.inUse[n22 + n] ? 1 : 0);
            }
        }
        this.bsPutBitsSmall(3, n9);
        this.bsPutBits(15, n6);
        int n23 = 6636321;
        for (n2 = 0; n2 < n6; ++n2) {
            int n24 = this.selectors[n2] & 0xFF;
            int n25 = n24 << 2;
            int n26 = n23 >>> n25 & 0xF;
            if (n26 != 1) {
                int n27 = 0x888888 - n23 + 0x111111 * n26 & 0x888888;
                n23 = n23 - (n26 << n25) + (n27 >>> 3);
            }
            this.bsPutBitsSmall(n26, (1 << n26) - 2);
        }
        for (n7 = 0; n7 < n9; ++n7) {
            byte[] byArray6 = byArray2[n7];
            int n28 = byArray6[0] & 0xFF;
            this.bsPutBitsSmall(6, n28 << 1);
            for (n2 = 1; n2 < n8; ++n2) {
                int n29 = byArray6[n2] & 0xFF;
                while (n28 < n29) {
                    this.bsPutBitsSmall(2, 2);
                    ++n28;
                }
                while (n28 > n29) {
                    this.bsPutBitsSmall(2, 3);
                    --n28;
                }
                this.bsPutBit(0);
            }
        }
        int n30 = 0;
        int n31 = 0;
        while (n31 < this.nMTF) {
            int n32 = Math.min(n31 + 50 - 1, this.nMTF - 1);
            int n33 = this.selectors[n30] & 0xFF;
            byte[] byArray7 = byArray2[n33];
            objectArray = nArray4[n33];
            for (n2 = n31; n2 <= n32; ++n2) {
                int n34 = this.szptr[n2];
                this.bsPutBits(byArray7[n34] & 0xFF, objectArray[n34]);
            }
            n31 = n32 + 1;
            ++n30;
        }
        if (n30 != n6) {
            throw new IllegalStateException();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutBits(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (INCS[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = INCS[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) > n + n6 - 1) continue;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        while (--n3 >= 0) {
            int n4 = this.zptr[n];
            int n5 = this.zptr[n2];
            this.zptr[n++] = n5;
            this.zptr[n2++] = n4;
        }
    }

    private int med3(int n, int n2, int n3) {
        return n > n2 ? (n3 < n2 ? n2 : (n3 > n ? n : n3)) : (n3 < n ? n : (n3 > n2 ? n2 : n3));
    }

    private static void pushStackElem(Vector vector, int n, int n2, int n3, int n4) {
        StackElem stackElem;
        if (n < vector.size()) {
            stackElem = (StackElem)vector.elementAt(n);
        } else {
            stackElem = new StackElem();
            vector.addElement(stackElem);
        }
        stackElem.ll = n2;
        stackElem.hh = n3;
        stackElem.dd = n4;
    }

    private void qSort3(int n, int n2, int n3) {
        Vector vector = this.blocksortStack;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        while (true) {
            int n8;
            int n9;
            int n10;
            if (n6 - n5 < 20 || n7 > 10) {
                this.simpleSort(n5, n6, n7);
                if (n4 < 1 || this.workDone > this.workLimit && this.firstAttempt) {
                    return;
                }
                StackElem stackElem = (StackElem)vector.elementAt(--n4);
                n5 = stackElem.ll;
                n6 = stackElem.hh;
                n7 = stackElem.dd;
                continue;
            }
            int n11 = n7 + 1;
            int n12 = this.med3(this.blockBytes[this.zptr[n5] + n11] & 0xFF, this.blockBytes[this.zptr[n6] + n11] & 0xFF, this.blockBytes[this.zptr[n5 + n6 >>> 1] + n11] & 0xFF);
            int n13 = n10 = n5;
            int n14 = n9 = n6;
            while (true) {
                int n15;
                if (n13 <= n14 && (n8 = (this.blockBytes[(n15 = this.zptr[n13]) + n11] & 0xFF) - n12) <= 0) {
                    if (n8 == 0) {
                        this.zptr[n13] = this.zptr[n10];
                        this.zptr[n10++] = n15;
                    }
                    ++n13;
                    continue;
                }
                while (n13 <= n14 && (n8 = (this.blockBytes[(n15 = this.zptr[n14]) + n11] & 0xFF) - n12) >= 0) {
                    if (n8 == 0) {
                        this.zptr[n14] = this.zptr[n9];
                        this.zptr[n9--] = n15;
                    }
                    --n14;
                }
                if (n13 > n14) break;
                n15 = this.zptr[n13];
                this.zptr[n13++] = this.zptr[n14];
                this.zptr[n14--] = n15;
            }
            if (n9 < n10) {
                n7 = n11;
                continue;
            }
            n8 = Math.min(n10 - n5, n13 - n10);
            this.vswap(n5, n13 - n8, n8);
            int n16 = Math.min(n6 - n9, n9 - n14);
            this.vswap(n13, n6 - n16 + 1, n16);
            n8 = n5 + (n13 - n10);
            n16 = n6 - (n9 - n14);
            CBZip2OutputStream.pushStackElem(vector, n4++, n5, n8 - 1, n7);
            CBZip2OutputStream.pushStackElem(vector, n4++, n8, n16, n11);
            n5 = n16 + 1;
        }
    }

    private void mainSort() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        for (n = 0; n < 20; ++n) {
            this.blockBytes[this.count + n + 1] = this.blockBytes[n % this.count + 1];
        }
        for (n = 0; n <= this.count + 20; ++n) {
            this.quadrantShorts[n] = 0;
        }
        this.blockBytes[0] = this.blockBytes[this.count];
        if (this.count <= 4000) {
            for (n = 0; n < this.count; ++n) {
                this.zptr[n] = n;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.count - 1, 0);
        } else {
            int n2;
            int n3;
            int n4;
            for (n = 0; n <= 255; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n <= 65536; ++n) {
                this.ftab[n] = 0;
            }
            int n5 = this.blockBytes[0] & 0xFF;
            for (n = 0; n < this.count; ++n) {
                n4 = this.blockBytes[n + 1] & 0xFF;
                int n6 = (n5 << 8) + n4;
                this.ftab[n6] = this.ftab[n6] + 1;
                n5 = n4;
            }
            for (n = 1; n <= 65536; ++n) {
                int n7 = n;
                this.ftab[n7] = this.ftab[n7] + this.ftab[n - 1];
            }
            n5 = this.blockBytes[1] & 0xFF;
            n = 0;
            while (n < this.count - 1) {
                n4 = this.blockBytes[n + 2] & 0xFF;
                n3 = (n5 << 8) + n4;
                n5 = n4;
                int n8 = n3;
                this.ftab[n8] = this.ftab[n8] - 1;
                this.zptr[this.ftab[n3]] = n++;
            }
            int n9 = n3 = ((this.blockBytes[this.count] & 0xFF) << 8) + (this.blockBytes[1] & 0xFF);
            this.ftab[n9] = this.ftab[n9] - 1;
            this.zptr[this.ftab[n3]] = this.count - 1;
            for (n = 0; n <= 255; ++n) {
                nArray[n] = n;
            }
            int n10 = 1;
            while ((n10 = 3 * n10 + 1) <= 256) {
            }
            do {
                for (n = n10 /= 3; n <= 255; ++n) {
                    n2 = nArray[n];
                    n3 = n;
                    while (this.ftab[nArray[n3 - n10] + 1 << 8] - this.ftab[nArray[n3 - n10] << 8] > this.ftab[n2 + 1 << 8] - this.ftab[n2 << 8]) {
                        nArray[n3] = nArray[n3 - n10];
                        if ((n3 -= n10) > n10 - 1) continue;
                    }
                    nArray[n3] = n2;
                }
            } while (n10 != 1);
            for (n = 0; n <= 255; ++n) {
                int n11 = nArray[n];
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n12 = (n11 << 8) + n3;
                    if ((this.ftab[n12] & 0x200000) == 0x200000) continue;
                    n10 = (this.ftab[n12 + 1] & 0xFFDFFFFF) - 1;
                    n2 = this.ftab[n12] & 0xFFDFFFFF;
                    if (n10 > n2) {
                        this.qSort3(n2, n10, 2);
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n13 = n12;
                    this.ftab[n13] = this.ftab[n13] | 0x200000;
                }
                blArray[n11] = true;
                if (n < 255) {
                    n2 = this.ftab[n11 << 8] & 0xFFDFFFFF;
                    n10 = (this.ftab[n11 + 1 << 8] & 0xFFDFFFFF) - n2;
                    int n14 = 0;
                    while (n10 >> n14 > 65534) {
                        ++n14;
                    }
                    for (n3 = 0; n3 < n10; ++n3) {
                        short s;
                        int n15 = this.zptr[n2 + n3] + 1;
                        this.quadrantShorts[n15] = s = (short)(n3 >> n14);
                        if (n15 > 20) continue;
                        this.quadrantShorts[n15 + this.count] = s;
                    }
                    if (n10 - 1 >> n14 > 65535) {
                        throw new IllegalStateException();
                    }
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    nArray2[n3] = this.ftab[(n3 << 8) + n11] & 0xFFDFFFFF;
                }
                for (n3 = this.ftab[n11 << 8] & 0xFFDFFFFF; n3 < (this.ftab[n11 + 1 << 8] & 0xFFDFFFFF); ++n3) {
                    n5 = this.blockBytes[this.zptr[n3]] & 0xFF;
                    if (blArray[n5]) continue;
                    this.zptr[nArray2[n5]] = (this.zptr[n3] == 0 ? this.count : this.zptr[n3]) - 1;
                    int n16 = n5;
                    nArray2[n16] = nArray2[n16] + 1;
                }
                for (n3 = 0; n3 <= 255; ++n3) {
                    int n17 = (n3 << 8) + n11;
                    this.ftab[n17] = this.ftab[n17] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int n;
        for (n = 0; n < 256; ++n) {
            this.inUse[n] = false;
        }
        n = 0;
        int n2 = 0;
        for (int i = 1; i <= this.count; ++i) {
            if (n == 0) {
                n = R_NUMS[n2++];
                n2 &= 0x1FF;
            }
            int n3 = i;
            this.blockBytes[n3] = (byte)(this.blockBytes[n3] ^ (--n == 1 ? (byte)1 : 0));
            this.inUse[this.blockBytes[i] & 0xFF] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * (this.count - 1);
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            throw new IllegalStateException();
        }
    }

    private boolean fullGtU(int n, int n2) {
        int n3;
        int n4;
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        int n5 = this.count;
        do {
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            int n6 = this.quadrantShorts[n] & 0xFFFF;
            int n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if (n >= this.count) {
                n -= this.count;
            }
            if (n2 >= this.count) {
                n2 -= this.count;
            }
            ++this.workDone;
        } while ((n5 -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        int n;
        int n2;
        this.nInUse = 0;
        byte[] byArray = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            if (!this.inUse[n2]) continue;
            byArray[this.nInUse++] = (byte)n2;
        }
        int n3 = this.nInUse + 1;
        for (n2 = 0; n2 <= n3; ++n2) {
            this.mtfFreq[n2] = 0;
        }
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.count; ++n2) {
            int n6;
            n = this.blockBytes[this.zptr[n2]];
            int n7 = byArray[0];
            if (n == n7) {
                ++n5;
                continue;
            }
            int n8 = 1;
            do {
                n6 = n7;
                n7 = byArray[n8];
                byArray[n8++] = n6;
            } while (n != n7);
            byArray[0] = n7;
            while (n5 > 0) {
                n6 = --n5 & 1;
                this.szptr[n4++] = n6;
                int n9 = n6;
                this.mtfFreq[n9] = this.mtfFreq[n9] + 1;
                n5 >>>= 1;
            }
            this.szptr[n4++] = n8;
            int n10 = n8;
            this.mtfFreq[n10] = this.mtfFreq[n10] + 1;
        }
        while (n5 > 0) {
            n = --n5 & 1;
            this.szptr[n4++] = n;
            int n11 = n;
            this.mtfFreq[n11] = this.mtfFreq[n11] + 1;
            n5 >>>= 1;
        }
        this.szptr[n4++] = n3;
        int n12 = n3;
        this.mtfFreq[n12] = this.mtfFreq[n12] + 1;
        this.nMTF = n4;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

