/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.apache.bzip2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.apache.bzip2.BZip2Constants;
import shadow.org.bouncycastle.apache.bzip2.CBZip2OutputStream;
import shadow.org.bouncycastle.apache.bzip2.CRC;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.Integers;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private final CRC blockCRC = new CRC();
    private int nInUse;
    private byte[] seqToUnseq = new byte[256];
    private byte[] selectors = new byte[18002];
    private int[] tt = null;
    private byte[] ll8 = null;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][21];
    private int[][] base = new int[6][21];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private InputStream bsStream;
    private boolean streamEnd = false;
    private int currentByte = -1;
    private static final int RAND_PART_B_STATE = 1;
    private static final int RAND_PART_C_STATE = 2;
    private static final int NO_RAND_PART_B_STATE = 3;
    private static final int NO_RAND_PART_C_STATE = 4;
    private int currentState = 0;
    private int expectedBlockCRC;
    private int expectedStreamCRC;
    private int streamCRC;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo = 0;
    int rTPos = 0;
    int j2;
    int z;

    public CBZip2InputStream(InputStream inputStream) throws IOException {
        this.bsStream = inputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
        int n = this.bsStream.read();
        int n2 = this.bsStream.read();
        int n3 = this.bsStream.read();
        int n4 = this.bsStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        if (n != 66 | n2 != 90 | n3 != 104 | n4 < 49 | n4 > 57) {
            throw new IOException("Invalid stream header");
        }
        this.blockSize100k = n4 - 48;
        int n5 = 100000 * this.blockSize100k;
        this.ll8 = new byte[n5];
        this.tt = new int[n5];
        this.streamCRC = 0;
        this.beginBlock();
    }

    @Override
    public void close() throws IOException {
        this.implClose(true);
    }

    @Override
    public int read() throws IOException {
        if (this.streamEnd) {
            return -1;
        }
        int n = this.currentByte;
        switch (this.currentState) {
            case 1: {
                this.setupRandPartB();
                break;
            }
            case 2: {
                this.setupRandPartC();
                break;
            }
            case 3: {
                this.setupNoRandPartB();
                break;
            }
            case 4: {
                this.setupNoRandPartC();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n;
    }

    private void beginBlock() throws IOException {
        long l = this.bsGetLong48();
        if (l != 54156738319193L) {
            if (l != 25779555029136L) {
                throw new IOException("Block header error");
            }
            this.expectedStreamCRC = this.bsGetInt32();
            if (this.expectedStreamCRC != this.streamCRC) {
                throw new IOException("Stream CRC error");
            }
            this.streamEnd = true;
            return;
        }
        this.expectedBlockCRC = this.bsGetInt32();
        boolean bl = this.bsGetBit() == 1;
        this.getAndMoveToFrontDecode();
        this.blockCRC.initialise();
        int[] nArray = new int[257];
        nArray[0] = 0;
        int n = 0;
        this.i = 0;
        while (this.i < 256) {
            nArray[this.i + 1] = n += this.unzftab[this.i];
            ++this.i;
        }
        if (n != this.last + 1) {
            throw new IllegalStateException();
        }
        this.i = 0;
        while (this.i <= this.last) {
            int n2 = n = this.ll8[this.i] & 0xFF;
            int n3 = nArray[n2];
            nArray[n2] = n3 + 1;
            this.tt[n3] = this.i++;
        }
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (bl) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void endBlock() throws IOException {
        int n = this.blockCRC.getFinal();
        if (this.expectedBlockCRC != n) {
            throw new IOException("Block CRC error");
        }
        this.streamCRC = Integers.rotateLeft(this.streamCRC, 1) ^ n;
    }

    private void implClose(boolean bl) throws IOException {
        if (this.bsStream != null) {
            if (bl) {
                this.bsStream.close();
            }
            this.bsStream = null;
        }
    }

    private int bsGetBit() throws IOException {
        if (this.bsLive == 0) {
            this.bsBuff = this.requireByte();
            this.bsLive = 7;
            return this.bsBuff >>> 7;
        }
        --this.bsLive;
        return this.bsBuff >>> this.bsLive & 1;
    }

    private int bsGetBits(int n) throws IOException {
        while (this.bsLive < n) {
            this.bsBuff = this.bsBuff << 8 | this.requireByte();
            this.bsLive += 8;
        }
        this.bsLive -= n;
        return this.bsBuff >>> this.bsLive & (1 << n) - 1;
    }

    private int bsGetBitsSmall(int n) throws IOException {
        if (this.bsLive < n) {
            this.bsBuff = this.bsBuff << 8 | this.requireByte();
            this.bsLive += 8;
        }
        this.bsLive -= n;
        return this.bsBuff >>> this.bsLive & (1 << n) - 1;
    }

    private int bsGetInt32() throws IOException {
        int n = this.bsGetBits(16) << 16;
        return n | this.bsGetBits(16);
    }

    private long bsGetLong48() throws IOException {
        long l = (long)this.bsGetBits(24) << 24;
        return l | (long)this.bsGetBits(24);
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray, int n, int n2, int n3) {
        Arrays.fill(nArray2, 0);
        Arrays.fill(nArray, 0);
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if ((byArray[j] & 0xFF) != i) continue;
                nArray3[n4++] = j;
            }
            nArray2[i] = n5;
            nArray[i] = n5 + n4;
            n5 += n5 + n4;
        }
    }

    private int recvDecodingTables() throws IOException {
        int n;
        int n2;
        int n3;
        this.nInUse = 0;
        int n4 = this.bsGetBits(16);
        for (n3 = 0; n3 < 16; ++n3) {
            if ((n4 & 32768 >>> n3) == 0) continue;
            n2 = this.bsGetBits(16);
            n = n3 * 16;
            for (int i = 0; i < 16; ++i) {
                if ((n2 & 32768 >>> i) == 0) continue;
                this.seqToUnseq[this.nInUse++] = (byte)(n + i);
            }
        }
        if (this.nInUse < 1) {
            throw new IllegalStateException();
        }
        n2 = this.nInUse + 2;
        n = this.bsGetBitsSmall(3);
        if (n < 2 || n > 6) {
            throw new IllegalStateException();
        }
        int n5 = this.bsGetBits(15);
        if (n5 < 1) {
            throw new IllegalStateException();
        }
        int n6 = 5517840;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = 0;
            while (this.bsGetBit() == 1) {
                if (++n7 < n) continue;
                throw new IllegalStateException();
            }
            if (n3 >= 18002) continue;
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    n6 = n6 >>> 4 & 0xF | n6 << 4 & 0xF0 | n6 & 0xFFFF00;
                    break;
                }
                case 2: {
                    n6 = n6 >>> 8 & 0xF | n6 << 4 & 0xFF0 | n6 & 0xFFF000;
                    break;
                }
                case 3: {
                    n6 = n6 >>> 12 & 0xF | n6 << 4 & 0xFFF0 | n6 & 0xFF0000;
                    break;
                }
                case 4: {
                    n6 = n6 >>> 16 & 0xF | n6 << 4 & 0xFFFF0 | n6 & 0xF00000;
                    break;
                }
                case 5: {
                    n6 = n6 >>> 20 & 0xF | n6 << 4 & 0xFFFFF0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.selectors[n3] = (byte)(n6 & 0xF);
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n; ++i) {
            int n8 = 0;
            int n9 = 32;
            int n10 = this.bsGetBitsSmall(5);
            if (n10 < 1 | n10 > 20) {
                throw new IllegalStateException();
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n11 = this.bsGetBit();
                while (n11 != 0) {
                    int n12 = this.bsGetBitsSmall(2);
                    if ((n10 += 1 - (n12 & 2)) < 1 | n10 > 20) {
                        throw new IllegalStateException();
                    }
                    n11 = n12 & 1;
                }
                byArray[n3] = (byte)n10;
                n8 = Math.max(n8, n10);
                n9 = Math.min(n9, n10);
            }
            this.hbCreateDecodeTables(this.limit[i], this.base[i], this.perm[i], byArray, n9, n8, n2);
            this.minLens[i] = n9;
        }
        return n5;
    }

    private void getAndMoveToFrontDecode() throws IOException {
        int n;
        int n2 = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetBits(24);
        if (this.origPtr > 10 + n2) {
            throw new IllegalStateException();
        }
        int n3 = this.recvDecodingTables();
        int n4 = this.nInUse + 2;
        int n5 = this.nInUse + 1;
        for (n = 0; n <= 255; ++n) {
            this.unzftab[n] = 0;
        }
        byte[] byArray = new byte[this.nInUse];
        for (n = 0; n < this.nInUse; ++n) {
            byArray[n] = this.seqToUnseq[n];
        }
        this.last = -1;
        int n6 = 0;
        int n7 = 49;
        int n8 = this.selectors[n6] & 0xFF;
        int n9 = this.minLens[n8];
        int[] nArray = this.limit[n8];
        int[] nArray2 = this.perm[n8];
        int[] nArray3 = this.base[n8];
        int n10 = n9;
        int n11 = this.bsGetBits(n9);
        while (n11 >= nArray[n10]) {
            if (++n10 > 20) {
                throw new IllegalStateException();
            }
            n11 = n11 << 1 | this.bsGetBit();
        }
        int n12 = n11 - nArray3[n10];
        if (n12 >= n4) {
            throw new IllegalStateException();
        }
        int n13 = nArray2[n12];
        while (n13 != n5) {
            int n14;
            if (n13 <= 1) {
                int n15;
                n10 = 1;
                n11 = 0;
                do {
                    if (n10 > 0x100000) {
                        throw new IllegalStateException();
                    }
                    n11 += n10 << n13;
                    n10 <<= 1;
                    if (n7 == 0) {
                        if (++n6 >= n3) {
                            throw new IllegalStateException();
                        }
                        n7 = 50;
                        n8 = this.selectors[n6] & 0xFF;
                        n9 = this.minLens[n8];
                        nArray = this.limit[n8];
                        nArray2 = this.perm[n8];
                        nArray3 = this.base[n8];
                    }
                    --n7;
                    n12 = n9;
                    n14 = this.bsGetBits(n9);
                    while (n14 >= nArray[n12]) {
                        if (++n12 > 20) {
                            throw new IllegalStateException();
                        }
                        n14 = n14 << 1 | this.bsGetBit();
                    }
                    n15 = n14 - nArray3[n12];
                    if (n15 < n4) continue;
                    throw new IllegalStateException();
                } while ((n13 = nArray2[n15]) <= 1);
                n12 = byArray[0];
                int n16 = n12 & 0xFF;
                this.unzftab[n16] = this.unzftab[n16] + n11;
                if (this.last >= n2 - n11) {
                    throw new IllegalStateException("Block overrun");
                }
                while (--n11 >= 0) {
                    this.ll8[++this.last] = n12;
                }
                continue;
            }
            if (++this.last >= n2) {
                throw new IllegalStateException("Block overrun");
            }
            n10 = byArray[n13 - 1];
            int n17 = n10 & 0xFF;
            this.unzftab[n17] = this.unzftab[n17] + 1;
            this.ll8[this.last] = n10;
            if (n13 <= 16) {
                for (int i = n13 - 1; i > 0; --i) {
                    byArray[i] = byArray[i - 1];
                }
            } else {
                System.arraycopy(byArray, 0, byArray, 1, n13 - 1);
            }
            byArray[0] = n10;
            if (n7 == 0) {
                if (++n6 >= n3) {
                    throw new IllegalStateException();
                }
                n7 = 50;
                n8 = this.selectors[n6] & 0xFF;
                n9 = this.minLens[n8];
                nArray = this.limit[n8];
                nArray2 = this.perm[n8];
                nArray3 = this.base[n8];
            }
            --n7;
            n11 = n9;
            n12 = this.bsGetBits(n9);
            while (n12 >= nArray[n11]) {
                if (++n11 > 20) {
                    throw new IllegalStateException();
                }
                n12 = n12 << 1 | this.bsGetBit();
            }
            n14 = n12 - nArray3[n11];
            if (n14 >= n4) {
                throw new IllegalStateException();
            }
            n13 = nArray2[n14];
        }
        if (this.origPtr > this.last) {
            throw new IllegalStateException();
        }
        n10 = this.last + 1;
        n11 = 0;
        for (n = 0; n <= 255; ++n) {
            n12 = this.unzftab[n];
            n11 |= n12;
            n11 |= n10 - n12;
        }
        if (n11 < 0) {
            throw new IllegalStateException();
        }
    }

    private int requireByte() throws IOException {
        int n = this.bsStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    private void setupRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = CBZip2OutputStream.R_NUMS[this.rTPos++];
                this.rTPos &= 0x1FF;
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentByte = this.ch2;
            this.currentState = 1;
            this.blockCRC.update(this.ch2);
        } else {
            this.endBlock();
            this.beginBlock();
        }
    }

    private void setupNoRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentByte = this.ch2;
            this.currentState = 3;
            this.blockCRC.update(this.ch2);
        } else {
            this.endBlock();
            this.beginBlock();
        }
    }

    private void setupRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.count = 1;
            this.setupRandPartA();
        } else if (++this.count < 4) {
            this.setupRandPartA();
        } else {
            this.z = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = CBZip2OutputStream.R_NUMS[this.rTPos++];
                this.rTPos &= 0x1FF;
            }
            --this.rNToGo;
            this.z ^= this.rNToGo == 1 ? 1 : 0;
            this.j2 = 0;
            this.currentState = 2;
            this.setupRandPartC();
        }
    }

    private void setupNoRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.count = 1;
            this.setupNoRandPartA();
        } else if (++this.count < 4) {
            this.setupNoRandPartA();
        } else {
            this.z = this.ll8[this.tPos] & 0xFF;
            this.tPos = this.tt[this.tPos];
            this.currentState = 4;
            this.j2 = 0;
            this.setupNoRandPartC();
        }
    }

    private void setupRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentByte = this.ch2;
            this.blockCRC.update(this.ch2);
            ++this.j2;
        } else {
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentByte = this.ch2;
            this.blockCRC.update(this.ch2);
            ++this.j2;
        } else {
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }
}

