/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli.bc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import shadow.org.bouncycastle.bcpg.ArmoredInputStream;
import shadow.org.bouncycastle.openpgp.PGPException;
import shadow.org.bouncycastle.openpgp.PGPPublicKey;
import shadow.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import shadow.org.bouncycastle.openpgp.PGPSignature;
import shadow.org.bouncycastle.openpgp.PGPSignatureList;
import shadow.org.bouncycastle.openpgp.PGPUtil;
import shadow.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import shadow.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import shadow.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

public class PgpSignatureVerifier {
    public static void verifySignature(String publicKeyId, String urlString, InputStream pluginZipInputStream, InputStream ascInputStream, InputStream publicKeyInputStream) throws IOException {
        try (InputStream fin = pluginZipInputStream;
             InputStream sin = ascInputStream;
             ArmoredInputStream ain = new ArmoredInputStream(publicKeyInputStream);){
            JcaPGPObjectFactory factory = new JcaPGPObjectFactory(PGPUtil.getDecoderStream(sin));
            PGPSignature signature = ((PGPSignatureList)factory.nextObject()).get(0);
            String keyId = Long.toHexString(signature.getKeyID()).toUpperCase(Locale.ROOT);
            if (!publicKeyId.equals(keyId)) {
                throw new IllegalStateException("key id [" + keyId + "] does not match expected key id [" + publicKeyId + "]");
            }
            PgpSignatureVerifier.computeSignatureForDownloadedPlugin(fin, ain, signature);
            if (!signature.verify()) {
                throw new IllegalStateException("signature verification for [" + urlString + "] failed");
            }
        }
        catch (PGPException e) {
            throw new IOException("PGP exception during signature verification for [" + urlString + "]", e);
        }
    }

    private static void computeSignatureForDownloadedPlugin(InputStream fin, InputStream ain, PGPSignature signature) throws PGPException, IOException {
        int read;
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(ain, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey key = collection.getPublicKey(signature.getKeyID());
        signature.init(new JcaPGPContentVerifierBuilderProvider(), key);
        byte[] buffer = new byte[1024];
        while ((read = fin.read(buffer)) != -1) {
            signature.update(buffer, 0, read);
        }
    }
}

