/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.jcajce.provider.snova;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.pqc.crypto.snova.SnovaPublicKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import shadow.org.bouncycastle.pqc.jcajce.interfaces.SnovaKey;
import shadow.org.bouncycastle.pqc.jcajce.spec.SnovaParameterSpec;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCSnovaPublicKey
implements PublicKey,
SnovaKey {
    private static final long serialVersionUID = 1L;
    private transient SnovaPublicKeyParameters params;

    public BCSnovaPublicKey(SnovaPublicKeyParameters snovaPublicKeyParameters) {
        this.params = snovaPublicKeyParameters;
    }

    public BCSnovaPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (SnovaPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSnovaPublicKey) {
            BCSnovaPublicKey bCSnovaPublicKey = (BCSnovaPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSnovaPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public SnovaParameterSpec getParameterSpec() {
        return SnovaParameterSpec.fromName(this.params.getParameters().getName());
    }

    SnovaPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

