/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.jcajce.provider.mayo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.pqc.crypto.mayo.MayoPublicKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import shadow.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import shadow.org.bouncycastle.pqc.jcajce.interfaces.MayoKey;
import shadow.org.bouncycastle.pqc.jcajce.spec.MayoParameterSpec;
import shadow.org.bouncycastle.util.Arrays;
import shadow.org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCMayoPublicKey
implements PublicKey,
MayoKey {
    private static final long serialVersionUID = 1L;
    private transient MayoPublicKeyParameters params;

    public BCMayoPublicKey(MayoPublicKeyParameters mayoPublicKeyParameters) {
        this.params = mayoPublicKeyParameters;
    }

    public BCMayoPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (MayoPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCMayoPublicKey) {
            BCMayoPublicKey bCMayoPublicKey = (BCMayoPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCMayoPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public MayoParameterSpec getParameterSpec() {
        return MayoParameterSpec.fromName(this.params.getParameters().getName());
    }

    MayoPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

