/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import shadow.org.bouncycastle.pqc.crypto.lms.Composer;
import shadow.org.bouncycastle.pqc.crypto.lms.HSSSignature;
import shadow.org.bouncycastle.pqc.crypto.lms.LMS;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSContext;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import shadow.org.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import shadow.org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HSSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int n, LMSPublicKeyParameters lMSPublicKeyParameters) {
        super(false);
        if (lMSPublicKeyParameters == null) {
            throw new NullPointerException("lmsPublicKey");
        }
        this.l = n;
        this.lmsPublicKey = lMSPublicKeyParameters;
    }

    public static HSSPublicKeyParameters getInstance(Object object) throws IOException {
        if (object instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            int n = ((DataInputStream)object).readInt();
            LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(object);
            return new HSSPublicKeyParameters(n, lMSPublicKeyParameters);
        }
        if (object instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(inputStream);
                return hSSPublicKeyParameters;
            }
        }
        if (object instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + String.valueOf(object));
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HSSPublicKeyParameters hSSPublicKeyParameters = (HSSPublicKeyParameters)object;
        if (this.l != hSSPublicKeyParameters.l) {
            return false;
        }
        return this.lmsPublicKey.equals(hSSPublicKeyParameters.lmsPublicKey);
    }

    public int hashCode() {
        int n = this.l;
        n = 31 * n + this.lmsPublicKey.hashCode();
        return n;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] byArray) {
        HSSSignature hSSSignature;
        try {
            hSSSignature = HSSSignature.getInstance(byArray, this.getL());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot parse signature: " + iOException.getMessage());
        }
        LMSSignedPubKey[] lMSSignedPubKeyArray = hSSSignature.getSignedPubKey();
        LMSPublicKeyParameters lMSPublicKeyParameters = lMSSignedPubKeyArray.length != 0 ? lMSSignedPubKeyArray[lMSSignedPubKeyArray.length - 1].getPublicKey() : this.getLMSPublicKey();
        return lMSPublicKeyParameters.generateOtsContext(hSSSignature.getSignature()).withSignedPublicKeys(lMSSignedPubKeyArray);
    }

    @Override
    public boolean verify(LMSContext lMSContext) {
        boolean bl = true;
        LMSSignedPubKey[] lMSSignedPubKeyArray = lMSContext.getSignedPubKeys();
        if (lMSSignedPubKeyArray.length != this.getL() - 1) {
            return false;
        }
        LMSPublicKeyParameters lMSPublicKeyParameters = this.getLMSPublicKey();
        for (int i = 0; i < lMSSignedPubKeyArray.length; ++i) {
            LMSSignature lMSSignature = lMSSignedPubKeyArray[i].getSignature();
            byte[] byArray = lMSSignedPubKeyArray[i].getPublicKey().toByteArray();
            bl &= LMS.verifySignature(lMSPublicKeyParameters, lMSSignature, byArray);
            lMSPublicKeyParameters = lMSSignedPubKeyArray[i].getPublicKey();
        }
        return bl & lMSPublicKeyParameters.verify(lMSContext);
    }
}

