/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import shadow.org.bouncycastle.math.ec.AbstractECLookupTable;
import shadow.org.bouncycastle.math.ec.ECConstants;
import shadow.org.bouncycastle.math.ec.ECCurve;
import shadow.org.bouncycastle.math.ec.ECFieldElement;
import shadow.org.bouncycastle.math.ec.ECLookupTable;
import shadow.org.bouncycastle.math.ec.ECPoint;
import shadow.org.bouncycastle.math.ec.custom.sec.SecP521R1Field;
import shadow.org.bouncycastle.math.ec.custom.sec.SecP521R1FieldElement;
import shadow.org.bouncycastle.math.ec.custom.sec.SecP521R1Point;
import shadow.org.bouncycastle.math.raw.Nat;
import shadow.org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SecP521R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP521R1FieldElement.Q;
    private static final int SECP521R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP521R1_AFFINE_ZS = new ECFieldElement[]{new SecP521R1FieldElement(ECConstants.ONE)};
    protected SecP521R1Point infinity = new SecP521R1Point(this, null, null);

    public SecP521R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00")));
        this.order = new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP521R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP521R1FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP521R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP521R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 17 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat.copy(17, ((SecP521R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 17);
            n3 += 17;
        }
        return new AbstractECLookupTable(this){
            final /* synthetic */ SecP521R1Curve this$0;
            {
                this.this$0 = secP521R1Curve;
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray3 = Nat.create(17);
                int[] nArray2 = Nat.create(17);
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 17; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 17 + j] & n3;
                    }
                    n22 += 34;
                }
                return this.createPoint(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray3 = Nat.create(17);
                int[] nArray2 = Nat.create(17);
                int n22 = n * 17 * 2;
                for (int i = 0; i < 17; ++i) {
                    int n3 = i;
                    nArray3[n3] = nArray3[n3] ^ nArray[n22 + i];
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] ^ nArray[n22 + 17 + i];
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return this.this$0.createRawPoint(new SecP521R1FieldElement(nArray3), new SecP521R1FieldElement(nArray2), SECP521R1_AFFINE_ZS);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.random(secureRandom, nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.randomMult(secureRandom, nArray);
        return new SecP521R1FieldElement(nArray);
    }
}

