/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.jcajce.provider.kdf.pbepbkdf2;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KDFParameters;
import javax.crypto.KDFSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import shadow.org.bouncycastle.crypto.Digest;
import shadow.org.bouncycastle.crypto.PasswordConverter;
import shadow.org.bouncycastle.crypto.digests.GOST3411Digest;
import shadow.org.bouncycastle.crypto.digests.SHA1Digest;
import shadow.org.bouncycastle.crypto.digests.SHA224Digest;
import shadow.org.bouncycastle.crypto.digests.SHA256Digest;
import shadow.org.bouncycastle.crypto.digests.SHA384Digest;
import shadow.org.bouncycastle.crypto.digests.SHA3Digest;
import shadow.org.bouncycastle.crypto.digests.SHA512Digest;
import shadow.org.bouncycastle.crypto.digests.SHA512tDigest;
import shadow.org.bouncycastle.crypto.digests.SM3Digest;
import shadow.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import shadow.org.bouncycastle.crypto.params.KeyParameter;
import shadow.org.bouncycastle.util.Arrays;

class PBEPBKDF2Spi
extends KDFSpi {
    final PasswordConverter pwdConverter;
    final PKCS5S2ParametersGenerator generator;

    protected PBEPBKDF2Spi(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
        this(kDFParameters, new SHA1Digest(), PasswordConverter.UTF8);
    }

    protected PBEPBKDF2Spi(KDFParameters kDFParameters, Digest digest) throws InvalidAlgorithmParameterException {
        this(kDFParameters, digest, PasswordConverter.UTF8);
    }

    protected PBEPBKDF2Spi(KDFParameters kDFParameters, Digest digest, PasswordConverter passwordConverter) throws InvalidAlgorithmParameterException {
        super(PBEPBKDF2Spi.requireNull(kDFParameters, "PBEPBKDF2 does not support parameters"));
        this.pwdConverter = passwordConverter;
        this.generator = new PKCS5S2ParametersGenerator(digest);
    }

    protected KDFParameters engineGetParameters() {
        return null;
    }

    protected SecretKey engineDeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        byte[] byArray = this.engineDeriveData(algorithmParameterSpec);
        return new SecretKeySpec(byArray, string);
    }

    protected byte[] engineDeriveData(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof PBEKeySpec)) {
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec provided");
        }
        PBEKeySpec pBEKeySpec = (PBEKeySpec)((Object)algorithmParameterSpec);
        char[] cArray = pBEKeySpec.getPassword();
        byte[] byArray = pBEKeySpec.getSalt();
        int n = pBEKeySpec.getIterationCount();
        int n2 = pBEKeySpec.getKeyLength();
        if (cArray == null || byArray == null) {
            throw new InvalidAlgorithmParameterException("Password and salt cannot be null");
        }
        this.generator.init(this.pwdConverter.convert(cArray), byArray, n);
        KeyParameter keyParameter = (KeyParameter)this.generator.generateDerivedParameters(n2);
        byte[] byArray2 = keyParameter.getKey();
        Arrays.fill(cArray, '\u0000');
        return byArray2;
    }

    private static KDFParameters requireNull(KDFParameters kDFParameters, String string) throws InvalidAlgorithmParameterException {
        if (kDFParameters != null) {
            throw new InvalidAlgorithmParameterException(string);
        }
        return null;
    }

    public static class PBKDF2withSM3
    extends PBEPBKDF2Spi {
        public PBKDF2withSM3(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SM3Digest());
        }

        public PBKDF2withSM3() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2with8BIT
    extends PBEPBKDF2Spi {
        public PBKDF2with8BIT(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA1Digest(), PasswordConverter.ASCII);
        }

        public PBKDF2with8BIT() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA3_512
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA3_512(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA3Digest(512));
        }

        public PBKDF2withSHA3_512() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA3_384
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA3_384(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA3Digest(384));
        }

        public PBKDF2withSHA3_384() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA3_256
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA3_256(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA3Digest(256));
        }

        public PBKDF2withSHA3_256() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA3_224
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA3_224(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA3Digest(224));
        }

        public PBKDF2withSHA3_224() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withGOST3411
    extends PBEPBKDF2Spi {
        public PBKDF2withGOST3411(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new GOST3411Digest());
        }

        public PBKDF2withGOST3411() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA512_256
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA512_256(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA512tDigest(256));
        }

        public PBKDF2withSHA512_256() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA512_224
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA512_224(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA512tDigest(224));
        }

        public PBKDF2withSHA512_224() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA512
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA512(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA512Digest());
        }

        public PBKDF2withSHA512() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA384
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA384(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA384Digest());
        }

        public PBKDF2withSHA384() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA256
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA256(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA256Digest());
        }

        public PBKDF2withSHA256() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withSHA224
    extends PBEPBKDF2Spi {
        public PBKDF2withSHA224(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA224Digest());
        }

        public PBKDF2withSHA224() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class PBKDF2withUTF8
    extends PBEPBKDF2Spi {
        public PBKDF2withUTF8(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA1Digest());
        }

        public PBKDF2withUTF8() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }
}

