/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.jcajce.provider.kdf.hkdf;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KDFParameters;
import javax.crypto.KDFSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.HKDFParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shadow.org.bouncycastle.crypto.Digest;
import shadow.org.bouncycastle.crypto.digests.SHA256Digest;
import shadow.org.bouncycastle.crypto.digests.SHA384Digest;
import shadow.org.bouncycastle.crypto.digests.SHA512Digest;
import shadow.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import shadow.org.bouncycastle.crypto.params.HKDFParameters;

class HKDFSpi
extends KDFSpi {
    protected HKDFBytesGenerator hkdf;

    public HKDFSpi(KDFParameters kDFParameters, Digest digest) throws InvalidAlgorithmParameterException {
        super(HKDFSpi.requireNull(kDFParameters, "HKDF does not support parameters"));
        this.hkdf = new HKDFBytesGenerator(digest);
    }

    protected KDFParameters engineGetParameters() {
        return null;
    }

    protected SecretKey engineDeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        byte[] byArray = this.engineDeriveData(algorithmParameterSpec);
        return new SecretKeySpec(byArray, string);
    }

    protected byte[] engineDeriveData(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof shadow.org.bouncycastle.jcajce.spec.HKDFParameterSpec) && !(algorithmParameterSpec instanceof HKDFParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec provided");
        }
        HKDFParameters hKDFParameters = null;
        int n = 0;
        if (algorithmParameterSpec instanceof HKDFParameterSpec.ExtractThenExpand) {
            HKDFParameterSpec.ExtractThenExpand extractThenExpand = (HKDFParameterSpec.ExtractThenExpand)algorithmParameterSpec;
            List list = extractThenExpand.ikms();
            List list2 = extractThenExpand.salts();
            hKDFParameters = new HKDFParameters(((SecretKey)list.get(0)).getEncoded(), ((SecretKey)list2.get(0)).getEncoded(), extractThenExpand.info());
            n = extractThenExpand.length();
            this.hkdf.init(hKDFParameters);
            byte[] byArray = new byte[n];
            this.hkdf.generateBytes(byArray, 0, n);
            return byArray;
        }
        if (algorithmParameterSpec instanceof HKDFParameterSpec.Extract) {
            HKDFParameterSpec.Extract extract = (HKDFParameterSpec.Extract)algorithmParameterSpec;
            List list = extract.ikms();
            List list3 = extract.salts();
            return this.hkdf.extractPRK(((SecretKey)list3.get(0)).getEncoded(), ((SecretKey)list.get(0)).getEncoded());
        }
        if (algorithmParameterSpec instanceof shadow.org.bouncycastle.jcajce.spec.HKDFParameterSpec) {
            shadow.org.bouncycastle.jcajce.spec.HKDFParameterSpec hKDFParameterSpec = (shadow.org.bouncycastle.jcajce.spec.HKDFParameterSpec)algorithmParameterSpec;
            hKDFParameters = new HKDFParameters(hKDFParameterSpec.getIKM(), hKDFParameterSpec.getSalt(), hKDFParameterSpec.getInfo());
            n = hKDFParameterSpec.getOutputLength();
            this.hkdf.init(hKDFParameters);
            byte[] byArray = new byte[n];
            this.hkdf.generateBytes(byArray, 0, n);
            return byArray;
        }
        throw new InvalidAlgorithmParameterException("invalid HKDFParameterSpec provided");
    }

    private static KDFParameters requireNull(KDFParameters kDFParameters, String string) throws InvalidAlgorithmParameterException {
        if (kDFParameters != null) {
            throw new InvalidAlgorithmParameterException(string);
        }
        return null;
    }

    public static class HKDFwithSHA512
    extends HKDFSpi {
        public HKDFwithSHA512(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA512Digest());
        }

        public HKDFwithSHA512() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class HKDFwithSHA384
    extends HKDFSpi {
        public HKDFwithSHA384(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA384Digest());
        }

        public HKDFwithSHA384() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }

    public static class HKDFwithSHA256
    extends HKDFSpi {
        public HKDFwithSHA256(KDFParameters kDFParameters) throws InvalidAlgorithmParameterException {
            super(kDFParameters, new SHA256Digest());
        }

        public HKDFwithSHA256() throws InvalidAlgorithmParameterException {
            this(null);
        }
    }
}

