/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.math.BigInteger;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import shadow.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import shadow.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import shadow.org.bouncycastle.util.Arrays;

class BC15EdDSAPublicKey
extends BCEdDSAPublicKey
implements EdECPublicKey {
    BC15EdDSAPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC15EdDSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(subjectPublicKeyInfo);
    }

    BC15EdDSAPublicKey(byte[] byArray, byte[] byArray2) throws InvalidKeySpecException {
        super(byArray, byArray2);
    }

    @Override
    public EdECPoint getPoint() {
        byte[] byArray = this.getPointEncoding();
        Arrays.reverseInPlace(byArray);
        boolean bl = (byArray[0] & 0x80) != 0;
        byArray[0] = (byte)(byArray[0] & 0x7F);
        return new EdECPoint(bl, new BigInteger(1, byArray));
    }

    @Override
    public NamedParameterSpec getParams() {
        if (this.eddsaPublicKey instanceof Ed448PublicKeyParameters) {
            return NamedParameterSpec.ED448;
        }
        return NamedParameterSpec.ED25519;
    }
}

