/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.interfaces.EdECPrivateKey;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import shadow.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shadow.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shadow.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import shadow.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import shadow.org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import shadow.org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPublicKey;
import shadow.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;

class BC15EdDSAPrivateKey
extends BCEdDSAPrivateKey
implements EdECPrivateKey {
    BC15EdDSAPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC15EdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public Optional<byte[]> getBytes() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return Optional.of(((Ed448PrivateKeyParameters)this.eddsaPrivateKey).getEncoded());
        }
        return Optional.of(((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).getEncoded());
    }

    @Override
    public NamedParameterSpec getParams() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return NamedParameterSpec.ED448;
        }
        return NamedParameterSpec.ED25519;
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return new BC15EdDSAPublicKey(((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
        }
        return new BC15EdDSAPublicKey(((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
    }
}

