/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutTransformAction
extends BaseRestHandler {
    static final ByteSizeValue MAX_REQUEST_SIZE = ByteSizeValue.ofMb((long)5L);

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_transform/{id}/"));
    }

    public String getName() {
        return "transform_put_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        if ((long)restRequest.contentLength() > MAX_REQUEST_SIZE.getBytes()) {
            throw ExceptionsHelper.badRequestException((String)"Request is too large: was [{}b], expected at most [{}]", (Object[])new Object[]{restRequest.contentLength(), MAX_REQUEST_SIZE});
        }
        String id = restRequest.param(TransformField.ID.getPreferredName());
        XContentParser parser = restRequest.contentParser();
        boolean deferValidation = restRequest.paramAsBoolean(TransformField.DEFER_VALIDATION.getPreferredName(), false);
        TimeValue timeout = restRequest.paramAsTime(TransformField.TIMEOUT.getPreferredName(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT);
        PutTransformAction.Request request = PutTransformAction.Request.fromXContent((XContentParser)parser, (String)id, (boolean)deferValidation, (TimeValue)timeout);
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)PutTransformAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

