/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;

public final class Releasables
extends Enum<Releasables> {
    private static final /* synthetic */ Releasables[] $VALUES;

    public static Releasables[] values() {
        return (Releasables[])$VALUES.clone();
    }

    public static Releasables valueOf(String name) {
        return Enum.valueOf(Releasables.class, name);
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        RuntimeException firstException = null;
        for (Releasable releasable : releasables) {
            try {
                Releasables.close(releasable);
            }
            catch (RuntimeException e) {
                firstException = Releasables.useOrSuppress(firstException, e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void close(@Nullable Releasable releasable) {
        if (releasable != null) {
            releasable.close();
        }
    }

    public static void close(Releasable ... releasables) {
        RuntimeException firstException = null;
        for (Releasable releasable : releasables) {
            try {
                Releasables.close(releasable);
            }
            catch (RuntimeException e) {
                firstException = Releasables.useOrSuppress(firstException, e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void closeExpectNoException(Releasable ... releasables) {
        try {
            Releasables.close(releasables);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeExpectNoException(Releasable releasable) {
        try {
            Releasables.close(releasable);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeWhileHandlingException(Releasable ... releasables) {
        for (Releasable releasable : releasables) {
            try {
                Releasables.close(releasable);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static RuntimeException useOrSuppress(RuntimeException firstException, RuntimeException e) {
        if (firstException == null || firstException == e) {
            return e;
        }
        firstException.addSuppressed(e);
        return firstException;
    }

    public static Releasable wrap(final Iterable<? extends Releasable> releasables) {
        return new Releasable(){

            @Override
            public void close() {
                Releasables.close(releasables);
            }

            public String toString() {
                return "wrapped[" + releasables + "]";
            }
        };
    }

    public static Releasable wrap(final Iterator<Releasable> releasables) {
        return Releasables.assertOnce(Releasables.wrap((Iterable<? extends Releasable>)new Iterable<Releasable>(){

            @Override
            public Iterator<Releasable> iterator() {
                return releasables;
            }

            public String toString() {
                return releasables.toString();
            }
        }));
    }

    public static Releasable wrap(final Releasable ... releasables) {
        return new Releasable(){

            @Override
            public void close() {
                Releasables.close(releasables);
            }

            public String toString() {
                return "wrapped" + Arrays.toString(releasables);
            }
        };
    }

    public static Releasable releaseOnce(Releasable releasable) {
        return new ReleaseOnce(releasable);
    }

    public static Releasable assertOnce(final Releasable delegate) {
        if (Assertions.ENABLED) {
            return new Releasable(){
                private final AtomicReference<Exception> firstCompletion = new AtomicReference();

                private void assertFirstRun() {
                    Exception previousRun = this.firstCompletion.compareAndExchange(null, new Exception("already executed"));
                    assert (previousRun == null) : new AssertionError(delegate.toString(), previousRun);
                }

                @Override
                public void close() {
                    this.assertFirstRun();
                    delegate.close();
                }

                public String toString() {
                    return delegate.toString();
                }

                public int hashCode() {
                    throw new AssertionError((Object)"almost certainly a mistake to need the hashCode() of a one-shot Releasable");
                }

                public boolean equals(Object obj) {
                    throw new AssertionError((Object)"almost certainly a mistake to compare a one-shot Releasable for equality");
                }
            };
        }
        return delegate;
    }

    private static /* synthetic */ Releasables[] $values() {
        return new Releasables[0];
    }

    static {
        $VALUES = Releasables.$values();
    }

    private static class ReleaseOnce
    extends AtomicReference<Releasable>
    implements Releasable {
        ReleaseOnce(Releasable releasable) {
            super(releasable);
        }

        @Override
        public void close() {
            Releasables.close((Releasable)this.getAndSet(null));
        }

        @Override
        public String toString() {
            return "releaseOnce[" + this.get() + "]";
        }
    }
}

