/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiPredicate;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.UnsupportedSelectorException;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexAbstractionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;

class IndicesAndAliasesResolver {
    private final IndexNameExpressionResolver nameExpressionResolver;
    private final IndexAbstractionResolver indexAbstractionResolver;
    private final RemoteClusterResolver remoteClusterResolver;

    IndicesAndAliasesResolver(Settings settings, ClusterService clusterService, IndexNameExpressionResolver resolver) {
        this.nameExpressionResolver = resolver;
        this.indexAbstractionResolver = new IndexAbstractionResolver(resolver);
        this.remoteClusterResolver = new RemoteClusterResolver(settings, clusterService.getClusterSettings());
    }

    ResolvedIndices resolve(String action, TransportRequest request, Metadata metadata, AuthorizationEngine.AuthorizedIndices authorizedIndices) {
        if (request instanceof IndicesAliasesRequest) {
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
            for (IndicesRequest indicesRequest : indicesAliasesRequest.getAliasActions()) {
                ResolvedIndices resolved = this.resolveIndicesAndAliases(action, indicesRequest, metadata, authorizedIndices);
                resolvedIndicesBuilder.addLocal(resolved.getLocal());
                resolvedIndicesBuilder.addRemote(resolved.getRemote());
            }
            return resolvedIndicesBuilder.build();
        }
        if (!(request instanceof IndicesRequest)) {
            throw new IllegalStateException("Request [" + request + "] is not an Indices request, but should be.");
        }
        return this.resolveIndicesAndAliases(action, (IndicesRequest)request, metadata, authorizedIndices);
    }

    @Nullable
    ResolvedIndices tryResolveWithoutWildcards(String action, TransportRequest transportRequest) {
        if (!(transportRequest instanceof IndicesRequest)) {
            return null;
        }
        IndicesRequest indicesRequest = (IndicesRequest)transportRequest;
        if (IndicesAndAliasesResolver.requiresWildcardExpansion(indicesRequest)) {
            return null;
        }
        return this.resolveIndicesAndAliasesWithoutWildcards(action, indicesRequest);
    }

    private static boolean requiresWildcardExpansion(IndicesRequest indicesRequest) {
        if (indicesRequest instanceof IndicesAliasesRequest) {
            return true;
        }
        return indicesRequest instanceof IndicesRequest.Replaceable;
    }

    ResolvedIndices resolveIndicesAndAliasesWithoutWildcards(String action, IndicesRequest indicesRequest) {
        ResolvedIndices split;
        IndicesRequest.SingleIndexNoWildcards single;
        assert (!IndicesAndAliasesResolver.requiresWildcardExpansion(indicesRequest)) : "request must not require wildcard expansion";
        Object[] indices = indicesRequest.indices();
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("the action " + action + " requires explicit index names, but none were provided");
        }
        if (IndexNameExpressionResolver.isAllIndices(Arrays.asList(indices), expr -> (String)IndexNameExpressionResolver.splitSelectorExpression((String)expr).v1())) {
            throw new IllegalArgumentException("the action " + action + " does not support accessing all indices; the provided index expression [" + Strings.arrayToCommaDelimitedString((Object[])indices) + "] is not allowed");
        }
        if (indicesRequest instanceof IndicesRequest.SingleIndexNoWildcards && (single = (IndicesRequest.SingleIndexNoWildcards)indicesRequest).allowsRemoteIndices()) {
            split = this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indicesRequest.indices());
            if (split.getLocal().isEmpty() && split.getRemote().isEmpty()) {
                for (Object indexExpression : indices) {
                    String[] clusterAndIndex = RemoteClusterAware.splitIndexName((String)indexExpression);
                    if (clusterAndIndex[0] == null || !clusterAndIndex[0].contains("*")) continue;
                    throw new NoSuchRemoteClusterException(clusterAndIndex[0]);
                }
            }
        } else {
            split = new ResolvedIndices(Arrays.asList(indicesRequest.indices()), List.of());
        }
        ArrayList<String> localIndices = new ArrayList<String>(split.getLocal().size());
        for (String localName : split.getLocal()) {
            String localExpression;
            Tuple expressionTuple = IndexNameExpressionResolver.splitSelectorExpression((String)localName);
            String selector = (String)expressionTuple.v2();
            if (selector != null && Regex.isSimpleMatchPattern((String)selector)) {
                IndicesAndAliasesResolver.throwOnUnexpectedWildcardSelectors(action, split.getLocal());
            }
            if (Regex.isSimpleMatchPattern((String)(localExpression = (String)expressionTuple.v1()))) {
                IndicesAndAliasesResolver.throwOnUnexpectedWildcards(action, split.getLocal());
            }
            String finalExpression = IndexNameExpressionResolver.resolveDateMathExpression((String)localExpression);
            if (selector != null) {
                finalExpression = IndexNameExpressionResolver.combineSelectorExpression((String)finalExpression, (String)selector);
            }
            localIndices.add(finalExpression);
        }
        return new ResolvedIndices(localIndices, split.getRemote());
    }

    ResolvedIndices resolvePITIndices(SearchRequest request) {
        assert (request.pointInTimeBuilder() != null);
        String[] indices = SearchContextId.decodeIndices((BytesReference)request.pointInTimeBuilder().getEncodedId());
        ResolvedIndices split = request.allowsRemoteIndices() ? this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indices) : new ResolvedIndices(Arrays.asList(indices), Collections.emptyList());
        if (split.isEmpty()) {
            return new ResolvedIndices(List.of("-*"), Collections.emptyList());
        }
        return split;
    }

    private static void throwOnUnexpectedWildcards(String action, List<String> indices) {
        List<String> wildcards = indices.stream().filter(Regex::isSimpleMatchPattern).toList();
        assert (!wildcards.isEmpty()) : "we already know that there's at least one wildcard in the indices";
        throw new IllegalArgumentException("the action " + action + " does not support wildcards; the provided index expression(s) [" + Strings.collectionToCommaDelimitedString(wildcards) + "] are not allowed");
    }

    private static void throwOnUnexpectedWildcardSelectors(String action, List<String> indices) {
        List<String> selectorExpressions = indices.stream().filter(IndexNameExpressionResolver::hasSelectorSuffix).toList();
        assert (!selectorExpressions.isEmpty()) : "we already know that there's at least one selector in the indices";
        throw new IllegalArgumentException("the action " + action + " does not support wildcard selectors; the provided index expression(s) [" + Strings.collectionToCommaDelimitedString(selectorExpressions) + "] are not allowed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ResolvedIndices resolveIndicesAndAliases(String action, IndicesRequest indicesRequest, Metadata metadata, AuthorizationEngine.AuthorizedIndices authorizedIndices) {
        ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
        boolean indicesReplacedWithNoIndices = false;
        if (indicesRequest instanceof PutMappingRequest && ((PutMappingRequest)indicesRequest).getConcreteIndex() != null) {
            assert (indicesRequest.indices() == null || indicesRequest.indices().length == 0) : "indices are: " + Arrays.toString(indicesRequest.indices());
            resolvedIndicesBuilder.addLocal(IndicesAndAliasesResolver.getPutMappingIndexOrAlias((PutMappingRequest)indicesRequest, (arg_0, arg_1) -> ((AuthorizationEngine.AuthorizedIndices)authorizedIndices).check(arg_0, arg_1), metadata));
        } else if (indicesRequest instanceof IndicesRequest.Replaceable) {
            boolean isAllIndices;
            IndicesRequest.Replaceable replaceable = (IndicesRequest.Replaceable)indicesRequest;
            IndicesOptions indicesOptions = indicesRequest.indicesOptions();
            String allIndicesPatternSelector = null;
            if (indicesRequest.indices() != null && indicesRequest.indices().length > 0) {
                isAllIndices = IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()), expr -> (String)IndexNameExpressionResolver.splitSelectorExpression((String)expr).v1());
                if (isAllIndices) {
                    allIndicesPatternSelector = (String)IndexNameExpressionResolver.splitSelectorExpression((String)IndicesAndAliasesResolver.indicesList(indicesRequest.indices()).get(0)).v2();
                }
            } else {
                isAllIndices = IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()));
            }
            if (isAllIndices) {
                if (!indicesOptions.allowSelectors() && allIndicesPatternSelector != null) {
                    String originalIndexExpression = indicesRequest.indices()[0];
                    throw new UnsupportedSelectorException(originalIndexExpression);
                }
                if (indicesOptions.expandWildcardExpressions()) {
                    IndexComponentSelector selector = IndexComponentSelector.getByKeyOrThrow(allIndicesPatternSelector);
                    for (String authorizedIndex : authorizedIndices.all(selector)) {
                        if (!IndexAbstractionResolver.isIndexVisible((String)"*", (String)allIndicesPatternSelector, (String)authorizedIndex, (IndicesOptions)indicesOptions, (Metadata)metadata, (IndexNameExpressionResolver)this.nameExpressionResolver, (boolean)indicesRequest.includeDataStreams())) continue;
                        resolvedIndicesBuilder.addLocal(IndexNameExpressionResolver.combineSelectorExpression((String)authorizedIndex, (String)allIndicesPatternSelector));
                    }
                }
            } else {
                ResolvedIndices split = replaceable.allowsRemoteIndices() ? this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indicesRequest.indices()) : new ResolvedIndices(Arrays.asList(indicesRequest.indices()), Collections.emptyList());
                List replaced = this.indexAbstractionResolver.resolveIndexAbstractions((Iterable)split.getLocal(), indicesOptions, metadata, arg_0 -> ((AuthorizationEngine.AuthorizedIndices)authorizedIndices).all(arg_0), (arg_0, arg_1) -> ((AuthorizationEngine.AuthorizedIndices)authorizedIndices).check(arg_0, arg_1), indicesRequest.includeDataStreams());
                resolvedIndicesBuilder.addLocal(replaced);
                resolvedIndicesBuilder.addRemote(split.getRemote());
            }
            if (resolvedIndicesBuilder.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) throw new IndexNotFoundException(Arrays.toString(indicesRequest.indices()));
                replaceable.indices(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY);
                indicesReplacedWithNoIndices = true;
                resolvedIndicesBuilder.addLocal("-*");
            } else {
                replaceable.indices(resolvedIndicesBuilder.build().toArray());
            }
        } else {
            assert (false) : "Request [" + indicesRequest + "] is not a replaceable request, but should be.";
            return this.resolveIndicesAndAliasesWithoutWildcards(action, indicesRequest);
        }
        if (!(indicesRequest instanceof AliasesRequest)) return resolvedIndicesBuilder.build();
        AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
        if (aliasesRequest.expandAliasesWildcards()) {
            List<String> aliases = IndicesAndAliasesResolver.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), IndicesAndAliasesResolver.loadAuthorizedAliases(authorizedIndices, metadata));
            aliasesRequest.replaceAliases(aliases.toArray(new String[aliases.size()]));
        }
        if (indicesReplacedWithNoIndices) {
            if (!(indicesRequest instanceof GetAliasesRequest)) {
                throw new IllegalStateException(GetAliasesRequest.class.getSimpleName() + " is the only known request implementing " + AliasesRequest.class.getSimpleName() + " that may allow no indices. Found [" + indicesRequest.getClass().getName() + "] which ended up with an empty set of indices.");
            }
        } else {
            resolvedIndicesBuilder.addLocal(aliasesRequest.aliases());
        }
        if (!aliasesRequest.expandAliasesWildcards() || aliasesRequest.aliases().length != 0) return resolvedIndicesBuilder.build();
        aliasesRequest.replaceAliases(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY);
        return resolvedIndicesBuilder.build();
    }

    static String getPutMappingIndexOrAlias(PutMappingRequest request, BiPredicate<String, IndexComponentSelector> isAuthorized, Metadata metadata) {
        String resolvedAliasOrIndex;
        String concreteIndexName = request.getConcreteIndex().getName();
        assert (!IndexNameExpressionResolver.hasSelectorSuffix((String)concreteIndexName)) : "selectors are not allowed in this context";
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(concreteIndexName);
        if (indexAbstraction == null) {
            resolvedAliasOrIndex = concreteIndexName;
        } else {
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
                throw new IllegalStateException("concrete index [" + concreteIndexName + "] is a [" + indexAbstraction.getType().getDisplayName() + "], but a concrete index is expected");
            }
            if (isAuthorized.test(concreteIndexName, IndexComponentSelector.DATA)) {
                resolvedAliasOrIndex = concreteIndexName;
            } else {
                Map foundAliases = metadata.findAllAliases(new String[]{concreteIndexName});
                List aliasMetadata = (List)foundAliases.get(concreteIndexName);
                if (aliasMetadata != null) {
                    Optional<String> foundAlias = aliasMetadata.stream().map(AliasMetadata::alias).filter(aliasName -> {
                        assert (!IndexNameExpressionResolver.hasSelectorSuffix((String)aliasName)) : "selectors are not allowed in this context";
                        if (!isAuthorized.test((String)aliasName, IndexComponentSelector.DATA)) {
                            return false;
                        }
                        IndexAbstraction alias = (IndexAbstraction)metadata.getIndicesLookup().get(aliasName);
                        List indices = alias.getIndices();
                        if (indices.size() == 1) {
                            return true;
                        }
                        assert (alias.getType() == IndexAbstraction.Type.ALIAS);
                        Index writeIndex = alias.getWriteIndex();
                        return writeIndex != null && writeIndex.getName().equals(concreteIndexName);
                    }).findFirst();
                    resolvedAliasOrIndex = foundAlias.orElse(concreteIndexName);
                } else {
                    resolvedAliasOrIndex = concreteIndexName;
                }
            }
        }
        return resolvedAliasOrIndex;
    }

    private static List<String> loadAuthorizedAliases(AuthorizationEngine.AuthorizedIndices authorizedIndices, Metadata metadata) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap existingAliases = metadata.getIndicesLookup();
        for (String authorizedIndex : authorizedIndices.all(IndexComponentSelector.DATA)) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)existingAliases.get(authorizedIndex);
            if (indexAbstraction == null || indexAbstraction.getType() != IndexAbstraction.Type.ALIAS) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private static List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        ArrayList<String> finalAliases = new ArrayList<String>();
        if (aliases.length == 0) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasExpression : aliases) {
            IndexNameExpressionResolver.assertExpressionHasNullOrDataSelector((String)aliasExpression);
            boolean include = true;
            if (aliasExpression.charAt(0) == '-') {
                include = false;
                aliasExpression = aliasExpression.substring(1);
            }
            if ("_all".equals(aliasExpression) || Regex.isSimpleMatchPattern((String)aliasExpression)) {
                HashSet<String> resolvedAliases = new HashSet<String>();
                for (String authorizedAlias : authorizedAliases) {
                    if (!"_all".equals(aliasExpression) && !Regex.simpleMatch((String)aliasExpression, (String)authorizedAlias)) continue;
                    resolvedAliases.add(authorizedAlias);
                }
                if (include) {
                    finalAliases.addAll(resolvedAliases);
                    continue;
                }
                finalAliases.removeAll(resolvedAliases);
                continue;
            }
            if (include) {
                finalAliases.add(aliasExpression);
                continue;
            }
            finalAliases.remove(aliasExpression);
        }
        return finalAliases;
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }

    private static class RemoteClusterResolver
    extends RemoteClusterAware {
        private final CopyOnWriteArraySet<String> clusters;

        private RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
            super(settings);
            this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.getEnabledRemoteClusters((Settings)settings));
            this.listenForUpdates(clusterSettings);
        }

        protected void updateRemoteCluster(String clusterAlias, Settings settings) {
            if (RemoteConnectionStrategy.isConnectionEnabled((String)clusterAlias, (Settings)settings)) {
                this.clusters.add(clusterAlias);
            } else {
                this.clusters.remove(clusterAlias);
            }
        }

        ResolvedIndices splitLocalAndRemoteIndexNames(String ... indices) {
            Map map = super.groupClusterIndices(this.clusters, indices);
            List local = (List)map.remove("");
            List remote = map.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> (String)e.getKey() + ":" + v)).toList();
            return new ResolvedIndices(local == null ? List.of() : local, remote);
        }
    }
}

