/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public class TransportGetUserPrivilegesAction
extends HandledTransportAction<GetUserPrivilegesRequest, GetUserPrivilegesResponse> {
    private final AuthorizationService authorizationService;
    private final SecurityContext securityContext;

    @Inject
    public TransportGetUserPrivilegesAction(TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/user/list_privileges", transportService, actionFilters, GetUserPrivilegesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.authorizationService = authorizationService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        this.securityContext.requireUser();
        Subject subject = this.securityContext.getAuthentication().getEffectiveSubject();
        if (!subject.getUser().principal().equals(request.username())) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only list the privileges of their own account"));
            return;
        }
        this.authorizationService.retrieveUserPrivileges(subject, this.securityContext.getAuthorizationInfoFromContext(), request.unwrapLimitedRole(), listener);
    }
}

