/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportDeleteRollupJobAction
extends TransportTasksAction<RollupJobTask, DeleteRollupJobAction.Request, DeleteRollupJobAction.Response, DeleteRollupJobAction.Response> {
    @Inject
    public TransportDeleteRollupJobAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:admin/xpack/rollup/delete", clusterService, transportService, actionFilters, DeleteRollupJobAction.Request::new, DeleteRollupJobAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void doExecute(Task task, DeleteRollupJobAction.Request request, ActionListener<DeleteRollupJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (nodes.isLocalNodeElectedMaster()) {
            PersistentTasksCustomMetadata pTasksMeta = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            if (pTasksMeta != null && pTasksMeta.getTask(request.getId()) != null) {
                super.doExecute(task, (BaseTasksRequest)request, listener);
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException("the task with id [" + request.getId() + "] doesn't exist", new Object[0]));
            }
        } else if (nodes.getMasterNode() == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException());
        } else {
            this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, DeleteRollupJobAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    protected void taskOperation(CancellableTask actionTask, DeleteRollupJobAction.Request request, RollupJobTask jobTask, ActionListener<DeleteRollupJobAction.Response> listener) {
        assert (jobTask.getConfig().getId().equals(request.getId()));
        IndexerState state = ((RollupJobStatus)jobTask.getStatus()).getIndexerState();
        if (state.equals((Object)IndexerState.STOPPED)) {
            jobTask.onCancelled();
            listener.onResponse((Object)new DeleteRollupJobAction.Response(true));
        } else {
            listener.onFailure((Exception)new IllegalStateException("Could not delete job [" + request.getId() + "] because indexer state is [" + state + "].  Job must be [" + IndexerState.STOPPED + "] before deletion."));
        }
    }

    protected DeleteRollupJobAction.Response newResponse(DeleteRollupJobAction.Request request, List<DeleteRollupJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        assert (tasks.size() + taskOperationFailures.size() == 1);
        boolean cancelled = tasks.size() > 0 && tasks.stream().allMatch(DeleteRollupJobAction.Response::isDeleted);
        return new DeleteRollupJobAction.Response(cancelled, taskOperationFailures, failedNodeExceptions);
    }
}

