/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MatchPhraseQuery
extends Query {
    private static final Map<String, BiConsumer<MatchPhraseQueryBuilder, Object>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), (qb, s) -> qb.analyzer(s.toString())), Map.entry(MatchPhraseQueryBuilder.SLOP_FIELD.getPreferredName(), (qb, s) -> qb.slop(Integer.parseInt(s.toString()))), Map.entry(MatchPhraseQueryBuilder.ZERO_TERMS_QUERY_FIELD.getPreferredName(), (qb, s) -> qb.zeroTermsQuery((String)s)), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), (qb, s) -> qb.boost(((Float)s).floatValue())));
    private final String name;
    private final Object text;
    private final Double boost;
    private final Map<String, Object> options;

    public MatchPhraseQuery(Source source, String name, Object text) {
        this(source, name, text, Map.of());
    }

    public MatchPhraseQuery(Source source, String name, Object text, Map<String, Object> options) {
        super(source);
        assert (options != null);
        this.name = name;
        this.text = text;
        this.options = options;
        this.boost = null;
    }

    protected QueryBuilder asBuilder() {
        MatchPhraseQueryBuilder queryBuilder = QueryBuilders.matchPhraseQuery((String)this.name, (Object)this.text);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal match_phrase option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, v);
        });
        if (this.boost != null) {
            queryBuilder.boost(this.boost.floatValue());
        }
        return queryBuilder;
    }

    public String name() {
        return this.name;
    }

    public Object text() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.name, this.options, this.boost);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MatchPhraseQuery other = (MatchPhraseQuery)((Object)obj);
        return Objects.equals(this.text, other.text) && Objects.equals(this.name, other.name) && Objects.equals(this.options, other.options) && Objects.equals(this.boost, other.boost);
    }

    protected String innerToString() {
        return this.name + ":" + this.text;
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public boolean scorable() {
        return true;
    }

    public boolean containsPlan() {
        return false;
    }
}

