/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.FilteredExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.function.grouping.Categorize;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Aggregate
extends UnaryPlan
implements PostAnalysisVerificationAware,
TelemetryAware,
SortAgnostic {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Aggregate", Aggregate::new);
    private final AggregateType aggregateType;
    private final List<Expression> groupings;
    private final List<? extends NamedExpression> aggregates;
    private List<Attribute> lazyOutput;

    public Aggregate(Source source, LogicalPlan child, AggregateType aggregateType, List<Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(source, child);
        this.aggregateType = aggregateType;
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    public Aggregate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), AggregateType.readType(in), in.readNamedWriteableCollectionAsList(Expression.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        AggregateType.writeType(out, this.aggregateType());
        out.writeNamedWriteableCollection(this.groupings);
        out.writeNamedWriteableCollection(this.aggregates());
    }

    public String getWriteableName() {
        return Aggregate.ENTRY.name;
    }

    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create((Node)this, Aggregate::new, (Object)((Object)this.child()), (Object)((Object)this.aggregateType), this.groupings, this.aggregates);
    }

    @Override
    public Aggregate replaceChild(LogicalPlan newChild) {
        return new Aggregate(this.source(), newChild, this.aggregateType, this.groupings, this.aggregates);
    }

    public Aggregate with(List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return this.with(this.child(), newGroupings, newAggregates);
    }

    public Aggregate with(LogicalPlan child, List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return new Aggregate(this.source(), child, this.aggregateType(), newGroupings, newAggregates);
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public List<Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    @Override
    public String telemetryLabel() {
        return switch (this.aggregateType) {
            default -> throw new IncompatibleClassChangeError();
            case AggregateType.STANDARD -> "STATS";
            case AggregateType.METRICS -> "METRICS";
        };
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && Resolvables.resolved(this.aggregates);
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = Aggregate.output(this.aggregates);
        }
        return this.lazyOutput;
    }

    public static List<Attribute> output(List<? extends NamedExpression> aggregates) {
        return NamedExpressions.mergeOutputAttributes(Expressions.asAttributes(aggregates), Collections.emptyList());
    }

    @Override
    protected AttributeSet computeReferences() {
        return Aggregate.computeReferences(this.aggregates, this.groupings);
    }

    public static AttributeSet computeReferences(List<? extends NamedExpression> aggregates, List<? extends Expression> groupings) {
        AttributeSet.Builder result = Expressions.references(groupings).combine(Expressions.references(aggregates)).asBuilder();
        for (Expression expression : groupings) {
            if (!(expression instanceof Alias)) continue;
            result.remove((Object)((Alias)expression).toAttribute());
        }
        return result.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregateType, this.groupings, this.aggregates, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)obj;
        return this.aggregateType == other.aggregateType && Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals((Object)this.child(), (Object)other.child());
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        AttributeSet.Builder groupRefsBuilder = AttributeSet.builder();
        this.groupings.forEach(e -> {
            FieldAttribute f;
            e.forEachUp(g -> {
                if (g instanceof AggregateFunction) {
                    AggregateFunction af = (AggregateFunction)g;
                    failures.add(Failure.fail(g, "cannot use an aggregate [{}] for grouping", new Object[]{af}));
                } else if (g instanceof GroupingFunction) {
                    GroupingFunction gf = (GroupingFunction)g;
                    gf.children().forEach(c -> c.forEachDown(GroupingFunction.class, inner -> failures.add(Failure.fail(inner, "cannot nest grouping functions; found [{}] inside [{}]", new Object[]{inner.sourceText(), gf.sourceText()}))));
                }
            });
            Attribute attr = Expressions.attribute((Expression)e);
            if (attr != null) {
                groupRefsBuilder.add(attr);
            }
            if (e instanceof FieldAttribute && (f = (FieldAttribute)e).dataType().isCounter()) {
                failures.add(Failure.fail(e, "cannot group by on [{}] type for grouping [{}]", new Object[]{f.dataType().typeName(), e.sourceText()}));
            }
        });
        AttributeSet groupRefs = groupRefsBuilder.build();
        this.aggregates.subList(0, this.aggregates.size() - this.groupings.size()).forEach(e -> {
            Expression exp = Alias.unwrap((Expression)e);
            if (exp.foldable()) {
                failures.add(Failure.fail(exp, "expected an aggregate function but found [{}]", new Object[]{exp.sourceText()}));
            }
            Aggregate.checkInvalidNamedExpressionUsage(exp, this.groupings, groupRefs, failures, 0);
        });
        if (this.aggregateType() == AggregateType.METRICS) {
            this.aggregates.forEach(a -> Aggregate.checkRateAggregates((Expression)a, 0, failures));
        } else {
            this.forEachExpression(Rate.class, r -> failures.add(Failure.fail(r, "the rate aggregate[{}] can only be used within the metrics command", new Object[]{r.sourceText()})));
        }
        this.checkCategorizeGrouping(failures);
        this.checkMultipleScoreAggregations(failures);
    }

    private void checkMultipleScoreAggregations(Failures failures) {
        Holder hasScoringAggs = new Holder();
        this.forEachExpression(FilteredExpression.class, fe -> {
            MetadataAttribute metadataAttribute;
            AggregateFunction aggregateFunction;
            Expression patt11008$temp;
            Expression patt10912$temp = fe.delegate();
            if (patt10912$temp instanceof AggregateFunction && (patt11008$temp = (aggregateFunction = (AggregateFunction)patt10912$temp).field()) instanceof MetadataAttribute && "_score".equals((metadataAttribute = (MetadataAttribute)patt11008$temp).name()) && fe.filter().anyMatch(e -> e instanceof FullTextFunction)) {
                failures.add(Failure.fail(fe, "cannot use _score aggregations with a WHERE filter in a STATS command", new Object[0]));
            }
        });
    }

    private void checkCategorizeGrouping(Failures failures) {
        if (this.groupings.size() > 1) {
            this.groupings.subList(1, this.groupings.size()).forEach(g -> g.forEachDown(Categorize.class, categorize -> failures.add(Failure.fail(categorize, "CATEGORIZE grouping function [{}] can only be in the first grouping expression", new Object[]{categorize.sourceText()}))));
        }
        this.groupings.forEach(g -> Alias.unwrap((Expression)g).children().forEach(child -> child.forEachDown(Categorize.class, c -> failures.add(Failure.fail(c, "CATEGORIZE grouping function [{}] can't be used within other expressions", new Object[]{c.sourceText()})))));
        this.aggregates.forEach(a -> a.forEachDown(AggregateFunction.class, aggregateFunction -> aggregateFunction.forEachDown(Categorize.class, categorize -> failures.add(Failure.fail(categorize, "cannot use CATEGORIZE grouping function [{}] within an aggregation", new Object[]{categorize.sourceText()})))));
        AttributeMap.Builder categorizeByAttributeBuilder = AttributeMap.builder();
        this.groupings.forEach(g -> g.forEachDown(Alias.class, alias -> {
            Expression patt13765$temp = alias.child();
            if (patt13765$temp instanceof Categorize) {
                Categorize categorize = (Categorize)patt13765$temp;
                categorizeByAttributeBuilder.put(alias.toAttribute(), (Object)categorize);
            }
        }));
        AttributeMap categorizeByAttribute = categorizeByAttributeBuilder.build();
        this.aggregates.forEach(a -> a.forEachDown(AggregateFunction.class, aggregate -> aggregate.forEachDown(Attribute.class, attribute -> {
            Categorize categorize = (Categorize)categorizeByAttribute.get(attribute);
            if (categorize != null) {
                failures.add(Failure.fail(attribute, "cannot reference CATEGORIZE grouping function [{}] within an aggregation", new Object[]{attribute.sourceText()}));
            }
        })));
        this.aggregates.forEach(a -> a.forEachDown(FilteredExpression.class, fe -> fe.filter().forEachDown(Attribute.class, attribute -> {
            Categorize categorize = (Categorize)categorizeByAttribute.get(attribute);
            if (categorize != null) {
                failures.add(Failure.fail(attribute, "cannot reference CATEGORIZE grouping function [{}] within an aggregation filter", new Object[]{attribute.sourceText()}));
            }
        })));
    }

    private static void checkRateAggregates(Expression expr, int nestedLevel, Failures failures) {
        if (expr instanceof AggregateFunction) {
            ++nestedLevel;
        }
        if (expr instanceof Rate) {
            Rate r = (Rate)expr;
            if (nestedLevel != 2) {
                failures.add(Failure.fail(expr, "the rate aggregate [{}] can only be used within the metrics command and inside another aggregate", new Object[]{r.sourceText()}));
            }
        }
        for (Expression child : expr.children()) {
            Aggregate.checkRateAggregates(child, nestedLevel, failures);
        }
    }

    private static void checkInvalidNamedExpressionUsage(Expression e, List<Expression> groups, AttributeSet groupRefs, Failures failures, int level) {
        block12: {
            block13: {
                GroupingFunction gf;
                block14: {
                    block11: {
                        if (e instanceof FilteredExpression) {
                            FilteredExpression fe = (FilteredExpression)e;
                            e = fe.delegate();
                            if (!e.anyMatch(AggregateFunction.class::isInstance)) {
                                Expression filter = fe.filter();
                                failures.add(Failure.fail(filter, "WHERE clause allowed only for aggregate functions, none found in [{}]", new Object[]{fe.sourceText()}));
                            }
                            Expression f2 = fe.filter();
                            Filter.checkFilterConditionDataType(f2, failures);
                            fe.filter().forEachDown(c -> {
                                if (c instanceof AggregateFunction) {
                                    AggregateFunction af = (AggregateFunction)c;
                                    failures.add(Failure.fail(af, "cannot use aggregate function [{}] in aggregate WHERE clause [{}]", new Object[]{af.sourceText(), fe.sourceText()}));
                                } else if (c instanceof GroupingFunction) {
                                    GroupingFunction gf = (GroupingFunction)c;
                                    if (c instanceof Categorize || !Expressions.anyMatch((List)groups, ex -> {
                                        Alias a;
                                        return ex instanceof Alias && (a = (Alias)ex).child().semanticEquals((Expression)gf);
                                    })) {
                                        failures.add(Failure.fail(gf, "can only use grouping function [{}] as part of the BY clause", new Object[]{gf.sourceText()}));
                                    }
                                }
                            });
                        }
                        if (!(e instanceof AggregateFunction)) break block11;
                        AggregateFunction af = (AggregateFunction)e;
                        af.field().forEachDown(AggregateFunction.class, f -> {
                            if (!(f instanceof Rate)) {
                                failures.add(Failure.fail(f, "nested aggregations [{}] not allowed inside other aggregations [{}]", new Object[]{f, af}));
                            }
                        });
                        break block12;
                    }
                    if (!(e instanceof GroupingFunction)) break block13;
                    gf = (GroupingFunction)e;
                    if (Expressions.anyMatch(groups, ex -> {
                        Alias a;
                        return ex instanceof Alias && (a = (Alias)ex).child().semanticEquals((Expression)gf);
                    })) break block14;
                    failures.add(Failure.fail(gf, "can only use grouping function [{}] as part of the BY clause", new Object[]{gf.sourceText()}));
                    break block12;
                }
                if (level != 0) break block12;
                Aggregate.addFailureOnGroupingUsedNakedInAggs(failures, (Expression)gf, "function");
                break block12;
            }
            if (!e.foldable()) {
                if (groups.contains(e) || groupRefs.contains((Object)e)) {
                    if (level == 0) {
                        Aggregate.addFailureOnGroupingUsedNakedInAggs(failures, e, "key");
                    }
                } else if (e instanceof NamedExpression) {
                    NamedExpression ne = (NamedExpression)e;
                    boolean foundInGrouping = false;
                    for (Expression g : groups) {
                        if (!g.anyMatch(se -> se.semanticEquals((Expression)ne))) continue;
                        foundInGrouping = true;
                        failures.add(Failure.fail(e, "column [{}] cannot be used as an aggregate once declared in the STATS BY grouping key [{}]", new Object[]{ne.name(), g.sourceText()}));
                        break;
                    }
                    if (!foundInGrouping) {
                        failures.add(Failure.fail(e, "column [{}] must appear in the STATS BY clause or be used in an aggregate function", new Object[]{ne.name()}));
                    }
                } else {
                    for (Expression child : e.children()) {
                        Aggregate.checkInvalidNamedExpressionUsage(child, groups, groupRefs, failures, level + 1);
                    }
                }
            }
        }
    }

    private static void addFailureOnGroupingUsedNakedInAggs(Failures failures, Expression e, String element) {
        failures.add(Failure.fail(e, "grouping {} [{}] cannot be used as an aggregate once declared in the STATS BY clause", new Object[]{element, e.sourceText()}));
    }

    public static enum AggregateType {
        STANDARD,
        METRICS;


        static void writeType(StreamOutput out, AggregateType type) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                out.writeString(type.name());
            } else if (type != STANDARD) {
                throw new IllegalStateException("cluster is not ready to support aggregate type [" + type + "]");
            }
        }

        static AggregateType readType(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
                return AggregateType.valueOf(in.readString());
            }
            return STANDARD;
        }
    }
}

