/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.StringPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPatternList;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCase;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RLike;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.WildcardLike;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStringCasingWithInsensitiveEquals;

public class ReplaceStringCasingWithInsensitiveRegexMatch
extends OptimizerRules.OptimizerExpressionRule<RegexMatch<? extends StringPattern>> {
    public ReplaceStringCasingWithInsensitiveRegexMatch() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected Expression rule(RegexMatch<? extends StringPattern> regexMatch, LogicalOptimizerContext unused) {
        Expression e = regexMatch;
        if (regexMatch.pattern() instanceof WildcardPatternList) {
            return e;
        }
        Expression expression = regexMatch.field();
        if (expression instanceof ChangeCase) {
            ChangeCase changeCase = (ChangeCase)expression;
            String pattern = regexMatch.pattern().pattern();
            e = changeCase.caseType().matchesCase(pattern) ? ReplaceStringCasingWithInsensitiveRegexMatch.insensitiveRegexMatch(regexMatch) : Literal.of(regexMatch, (Object)Boolean.FALSE);
        }
        return e;
    }

    private static Expression insensitiveRegexMatch(RegexMatch<? extends StringPattern> regexMatch) {
        if (regexMatch instanceof RLike) {
            RLike rLike = (RLike)regexMatch;
            return new RLike(rLike.source(), ReplaceStringCasingWithInsensitiveEquals.unwrapCase(rLike.field()), (RLikePattern)rLike.pattern(), true);
        }
        if (regexMatch instanceof WildcardLike) {
            WildcardLike wildcardLike = (WildcardLike)regexMatch;
            return new WildcardLike(wildcardLike.source(), ReplaceStringCasingWithInsensitiveEquals.unwrapCase(wildcardLike.field()), (WildcardPattern)wildcardLike.pattern(), true);
        }
        return regexMatch;
    }
}

