/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.completion;

import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.esql.inference.InferenceOperator;

public class CompletionOperatorOutputBuilder
implements InferenceOperator.OutputBuilder {
    private final Page inputPage;
    private final BytesRefBlock.Builder outputBlockBuilder;
    private final BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();

    public CompletionOperatorOutputBuilder(BytesRefBlock.Builder outputBlockBuilder, Page inputPage) {
        this.inputPage = inputPage;
        this.outputBlockBuilder = outputBlockBuilder;
    }

    public void close() {
        Releasables.close((Releasable)this.outputBlockBuilder);
        this.releasePageOnAnyThread(this.inputPage);
    }

    @Override
    public void addInferenceResponse(InferenceAction.Response inferenceResponse) {
        if (inferenceResponse == null) {
            this.outputBlockBuilder.appendNull();
            return;
        }
        ChatCompletionResults completionResults = this.inferenceResults(inferenceResponse);
        if (completionResults == null) {
            throw new IllegalStateException("Received null inference result; expected a non-null result of type ChatCompletionResults");
        }
        this.outputBlockBuilder.beginPositionEntry();
        for (ChatCompletionResults.Result completionResult : completionResults.getResults()) {
            this.bytesRefBuilder.copyChars((CharSequence)completionResult.content());
            this.outputBlockBuilder.appendBytesRef(this.bytesRefBuilder.get());
            this.bytesRefBuilder.clear();
        }
        this.outputBlockBuilder.endPositionEntry();
    }

    @Override
    public Page buildOutput() {
        BytesRefBlock outputBlock = this.outputBlockBuilder.build();
        assert (outputBlock.getPositionCount() == this.inputPage.getPositionCount());
        return this.inputPage.shallowCopy().appendBlock((Block)outputBlock);
    }

    private ChatCompletionResults inferenceResults(InferenceAction.Response inferenceResponse) {
        return InferenceOperator.OutputBuilder.inferenceResults(inferenceResponse, ChatCompletionResults.class);
    }
}

